/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.matrix.data.LibCommonsMath;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class MultiReturnBuiltinCPInstruction
extends ComputationCPInstruction {
    protected ArrayList<CPOperand> _outputs;

    private MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, null, outputs.get(0), opcode, istr);
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public static MultiReturnBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qr")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("lu")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("eigen")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("svd")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in, this.getOpcode());
        ec.releaseMatrixInput(this.input1.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        ArrayList<LineageItem> items = new ArrayList<LineageItem>();
        for (CPOperand out : this._outputs) {
            items.add(new LineageItem(out.getName(), this.getOpcode(), inputLineage));
        }
        return items.toArray(new LineageItem[items.size()]);
    }
}

