/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.IndexRange;
import org.tugraz.sysds.utils.Statistics;

public final class MatrixIndexingCPInstruction
extends IndexingCPInstruction {
    public MatrixIndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected MatrixIndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        if (opcode.equalsIgnoreCase("rightIndex")) {
            MatrixBlock resultBlock = null;
            if (mo.isPartitioned()) {
                resultBlock = mo.readMatrixPartition(ixrange.add(1));
            } else {
                MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
                resultBlock = matBlock.slice((int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, false, new MatrixBlock());
                ec.releaseMatrixInput(this.input1.getName());
                if (this.checkGuardedRepresentationChange(matBlock, resultBlock)) {
                    resultBlock.examSparsity();
                }
            }
            ec.setMatrixOutput(this.output.getName(), resultBlock);
        } else if (opcode.equalsIgnoreCase("leftIndex")) {
            MatrixObject.UpdateType updateType = mo.getUpdateType();
            if (DMLScript.STATISTICS) {
                if (updateType.isInPlace()) {
                    Statistics.incrementTotalLixUIP();
                }
                Statistics.incrementTotalLix();
            }
            MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
            MatrixBlock resultBlock = null;
            if (this.input2.getDataType() == Types.DataType.MATRIX) {
                MatrixBlock rhsMatBlock = ec.getMatrixInput(this.input2.getName());
                resultBlock = matBlock.leftIndexingOperations(rhsMatBlock, ixrange, new MatrixBlock(), updateType);
                ec.releaseMatrixInput(this.input2.getName());
            } else {
                if (!ixrange.isScalar()) {
                    throw new DMLRuntimeException("Invalid index range of scalar leftindexing: " + ixrange.toString() + ".");
                }
                ScalarObject scalar = ec.getScalarInput(this.input2.getName(), Types.ValueType.FP64, this.input2.isLiteral());
                resultBlock = matBlock.leftIndexingOperations(scalar, (int)ixrange.rowStart, (int)ixrange.colStart, new MatrixBlock(), updateType);
            }
            ec.releaseMatrixInput(this.input1.getName());
            resultBlock.examSparsity();
            ec.setMatrixOutput(this.output.getName(), resultBlock, updateType, this.getExtendedOpcode());
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in MatrixIndexingCPInstruction.");
        }
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.rowLower, this.rowUpper, this.colLower, this.colUpper))};
    }
}

