/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class MatrixBuiltinNaryCPInstruction
extends BuiltinNaryCPInstruction
implements LineageTraceable {
    protected MatrixBuiltinNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand[] inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        List<MatrixBlock> matrices = ec.getMatrixInputs(this.inputs, true);
        List<ScalarObject> scalars = ec.getScalarInputs(this.inputs);
        MatrixBlock outBlock = null;
        if ("cbind".equals(this.getOpcode()) || "rbind".equals(this.getOpcode())) {
            boolean cbind = "cbind".equals(this.getOpcode());
            outBlock = matrices.get(0).append(matrices.subList(1, matrices.size()).toArray(new MatrixBlock[0]), new MatrixBlock(), cbind);
        } else if (ArrayUtils.contains((Object[])new String[]{"nmin", "nmax", "n+"}, (Object)this.getOpcode())) {
            outBlock = MatrixBlock.naryOperations(this._optr, matrices.toArray(new MatrixBlock[0]), scalars.toArray(new ScalarObject[0]), new MatrixBlock());
        } else {
            throw new DMLRuntimeException("Unknown opcode: " + this.getOpcode());
        }
        ec.releaseMatrixInputs(this.inputs, true);
        if (this.output.getDataType().isMatrix()) {
            ec.setMatrixOutput(this.output.getName(), outBlock);
        } else {
            ec.setVariable(this.output.getName(), ScalarObjectFactory.createScalarObject(this.output.getValueType(), outBlock.quickGetValue(0, 0)));
        }
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.inputs))};
    }
}

