/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.lineage.LineageItem;

public class ListObject
extends Data {
    private static final long serialVersionUID = 3652422061598967358L;
    private final List<Data> _data;
    private boolean[] _dataState = null;
    private List<String> _names = null;
    private int _nCacheable;
    private List<LineageItem> _lineage = null;

    public ListObject(List<Data> data) {
        this(data, null, null);
    }

    public ListObject(List<Data> data, List<String> names) {
        this(data, names, null);
    }

    public ListObject(List<Data> data, List<String> names, List<LineageItem> lineage) {
        super(Types.DataType.LIST, Types.ValueType.UNKNOWN);
        this._data = data;
        this._names = names;
        this._lineage = lineage;
        this._nCacheable = (int)data.stream().filter(d -> d instanceof CacheableData).count();
    }

    public ListObject(ListObject that) {
        this(new ArrayList<Data>(that._data), that._names != null ? new ArrayList<String>(that._names) : null, (List<LineageItem>)(that._lineage != null ? new ArrayList<LineageItem>(that._lineage) : null));
        if (that._dataState != null) {
            this._dataState = Arrays.copyOf(that._dataState, this.getLength());
        }
    }

    public void deriveAndSetStatusFromData() {
        this._dataState = new boolean[this._data.size()];
        for (int i = 0; i < this._data.size(); ++i) {
            Data dat = this._data.get(i);
            if (!(dat instanceof CacheableData)) continue;
            this._dataState[i] = ((CacheableData)dat).isCleanupEnabled();
        }
    }

    public void setStatus(boolean[] status) {
        this._dataState = status;
    }

    public boolean[] getStatus() {
        return this._dataState;
    }

    public int getLength() {
        return this._data.size();
    }

    public int getNumCacheableData() {
        return this._nCacheable;
    }

    public List<String> getNames() {
        return this._names;
    }

    public String getName(int ix) {
        return this._names == null ? null : this._names.get(ix);
    }

    public boolean isNamedList() {
        return this._names != null;
    }

    public List<Data> getData() {
        return this._data;
    }

    public List<LineageItem> getLineageItems() {
        return this._lineage;
    }

    public long getDataSize() {
        return this._data.stream().filter(data -> data instanceof CacheableData).mapToLong(data -> ((CacheableData)data).getDataSize()).sum();
    }

    public boolean checkAllDataTypes(Types.DataType dt) {
        return this._data.stream().allMatch(d -> d.getDataType() == dt);
    }

    public Data slice(int ix) {
        return this._data.get(ix);
    }

    public LineageItem getLineageItem(int ix) {
        LineageItem li = this._lineage != null ? this._lineage.get(ix) : null;
        return li;
    }

    public ListObject slice(int ix1, int ix2) {
        ListObject ret = new ListObject(this._data.subList(ix1, ix2 + 1), this._names != null ? this._names.subList(ix1, ix2 + 1) : null, this._lineage != null ? this._lineage.subList(ix1, ix2 + 1) : null);
        if (this._dataState != null) {
            ret.setStatus(Arrays.copyOfRange(this._dataState, ix2, ix2 + 1));
        }
        return ret;
    }

    public Data slice(String name) {
        int pos = this.getPosForName(name);
        return this.slice(pos);
    }

    public ListObject slice(String name1, String name2) {
        int pos1 = this.getPosForName(name1);
        int pos2 = this.getPosForName(name2);
        return this.slice(pos1, pos2);
    }

    public ListObject copy() {
        ArrayList<String> names = this.isNamedList() ? new ArrayList<String>(this.getNames()) : null;
        ArrayList<LineageItem> LineageItems = this.getLineageItems() != null ? new ArrayList<LineageItem>(this.getLineageItems()) : null;
        ListObject ret = new ListObject(new ArrayList<Data>(this.getData()), names, LineageItems);
        if (this.getStatus() != null) {
            ret.setStatus(Arrays.copyOf(this.getStatus(), this.getLength()));
        }
        return ret;
    }

    public ListObject set(int ix, Data data) {
        this._data.set(ix, data);
        return this;
    }

    public ListObject set(int ix1, int ix2, ListObject data) {
        int range = ix2 - ix1 + 1;
        if (range != data.getLength() || range > this.getLength()) {
            throw new DMLRuntimeException("List leftindexing size mismatch: length(lhs)=" + this.getLength() + ", range=[" + ix1 + ":" + ix2 + "], legnth(rhs)=" + data.getLength());
        }
        if (range == this.getLength()) {
            this._data.clear();
            this._data.addAll(data.getData());
            System.arraycopy(data.getStatus(), 0, this._dataState, 0, range);
            if (data.isNamedList()) {
                this._names = new ArrayList<String>(data.getNames());
            }
        } else {
            for (int i = ix1; i <= ix2; ++i) {
                this.set(i, data.slice(i - ix1));
                this._dataState[i] = data._dataState[i - ix1];
                if (!this.isNamedList() || !data.isNamedList()) continue;
                this._names.set(i, data.getName(i - ix1));
            }
        }
        return this;
    }

    public Data set(String name, Data data) {
        int pos = this.getPosForName(name);
        return this.set(pos, data);
    }

    public ListObject set(String name1, String name2, ListObject data) {
        int pos1 = this.getPosForName(name1);
        int pos2 = this.getPosForName(name2);
        return this.set(pos1, pos2, data);
    }

    public ListObject add(Data dat, LineageItem li) {
        this.add(null, dat, li);
        return this;
    }

    public ListObject add(String name, Data dat, LineageItem li) {
        if (this._names != null && name == null) {
            throw new DMLRuntimeException("Cannot add to a named list");
        }
        this._data.add(dat);
        if (this._lineage == null && li != null) {
            this._lineage = new ArrayList<LineageItem>();
        }
        if (li != null) {
            this._lineage.add(li);
        }
        return this;
    }

    public ListObject remove(int pos) {
        ListObject ret = new ListObject(Arrays.asList(this._data.get(pos)), null, this._lineage != null ? Arrays.asList(this._lineage.get(pos)) : null);
        this._data.remove(pos);
        if (this._lineage != null) {
            this._lineage.remove(pos);
        }
        if (this._names != null) {
            this._names.remove(pos);
        }
        return ret;
    }

    private int getPosForName(String name) {
        if (this._names == null) {
            throw new DMLRuntimeException("Invalid indexing by name in unnamed list: " + name + ".");
        }
        int pos = this._names.indexOf(name);
        if (pos < 0 || pos >= this._data.size()) {
            throw new DMLRuntimeException("List indexing returned no entry for name='" + name + "'");
        }
        return pos;
    }

    @Override
    public String getDebugName() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("List (");
        for (int i = 0; i < this._data.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this._names != null) {
                sb.append(this._names.get(i));
                sb.append("=");
            }
            sb.append(this._data.get(i).toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

