/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.AppendCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public final class ListAppendRemoveCPInstruction
extends AppendCPInstruction {
    private CPOperand output2 = null;

    protected ListAppendRemoveCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, out, type, opcode, istr);
        if (opcode.equals("remove")) {
            this.output2 = new CPOperand(InstructionUtils.getInstructionPartsWithValueType(istr)[4]);
        }
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ListObject lo = ec.getListObject(this.input1);
        if (this.getOpcode().equals("append")) {
            Data dat2 = ec.getVariable(this.input2);
            LineageItem li = DMLScript.LINEAGE ? ec.getLineage().get(this.input2) : null;
            ListObject tmp = lo.copy().add(dat2, li);
            ec.setVariable(this.output.getName(), tmp);
        } else if (this.getOpcode().equals("remove")) {
            ScalarObject dat2 = ec.getScalarInput(this.input2);
            ListObject tmp1 = lo.copy();
            ListObject tmp2 = tmp1.remove((int)dat2.getLongValue() - 1);
            ec.setVariable(this.output.getName(), tmp1);
            ec.setVariable(this.output2.getName(), tmp2);
        } else {
            throw new DMLRuntimeException("Unsupported list operation: " + this.getOpcode());
        }
    }
}

