/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.instructions.cp.Data;

public class KahanObject
extends Data {
    private static final long serialVersionUID = -5331529073327676437L;
    public double _sum;
    public double _correction;

    public KahanObject(double sum, double cor) {
        super(Types.DataType.UNKNOWN, Types.ValueType.UNKNOWN);
        this._sum = sum;
        this._correction = cor;
    }

    public String toString() {
        return "(" + this._sum + ", " + this._correction + ")";
    }

    public static int compare(KahanObject k1, KahanObject k2) {
        if (k1._sum != k2._sum) {
            return Double.compare(k1._sum, k2._sum);
        }
        return Double.compare(k1._correction, k2._correction);
    }

    public boolean equals(Object o) {
        if (!(o instanceof KahanObject)) {
            return false;
        }
        KahanObject that = (KahanObject)o;
        return this._sum == that._sum && this._correction == that._correction;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    public void read(DataInput in) throws IOException {
        this._sum = in.readDouble();
        this._correction = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this._sum);
        out.writeDouble(this._correction);
    }

    public void set(KahanObject that) {
        this._sum = that._sum;
        this._correction = that._correction;
    }

    public void set(double s, double c) {
        this._sum = s;
        this._correction = c;
    }

    public boolean isAllZero() {
        return this._sum == 0.0 && this._correction == 0.0;
    }

    @Override
    public String getDebugName() {
        return null;
    }
}

