/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.DMLScriptException;
import org.tugraz.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.lineage.Lineage;
import org.tugraz.sysds.runtime.lineage.LineageCache;
import org.tugraz.sysds.runtime.lineage.LineageCacheStatistics;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.utils.Statistics;

public class FunctionCallCPInstruction
extends CPInstruction {
    private final String _functionName;
    private final String _namespace;
    private final CPOperand[] _boundInputs;
    private final List<String> _boundInputNames;
    private final List<String> _funArgNames;
    private final List<String> _boundOutputNames;

    public FunctionCallCPInstruction(String namespace, String functName, CPOperand[] boundInputs, List<String> boundInputNames, List<String> funArgNames, List<String> boundOutputNames, String istr) {
        super(CPInstruction.CPType.External, null, functName, istr);
        this._functionName = functName;
        this._namespace = namespace;
        this._boundInputs = boundInputs;
        this._boundInputNames = boundInputNames;
        this._funArgNames = funArgNames;
        this._boundOutputNames = boundOutputNames;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public static FunctionCallCPInstruction parseInstruction(String str) {
        int i;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String namespace = parts[1];
        String functionName = parts[2];
        int numInputs = Integer.valueOf(parts[3]);
        int numOutputs = Integer.valueOf(parts[4]);
        CPOperand[] boundInputs = new CPOperand[numInputs];
        ArrayList<String> boundInputNames = new ArrayList<String>();
        ArrayList<String> funArgNames = new ArrayList<String>();
        ArrayList<String> boundOutputNames = new ArrayList<String>();
        for (i = 0; i < numInputs; ++i) {
            String[] nameValue = IOUtilFunctions.splitByFirst(parts[5 + i], "=");
            boundInputs[i] = new CPOperand(nameValue[1]);
            funArgNames.add(nameValue[0]);
            boundInputNames.add(boundInputs[i].getName());
        }
        for (i = 0; i < numOutputs; ++i) {
            boundOutputNames.add(parts[5 + numInputs + i]);
        }
        return new FunctionCallCPInstruction(namespace, functionName, boundInputs, boundInputNames, funArgNames, boundOutputNames, str);
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        return super.preprocessInstruction(ec);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        LineageItem[] liInputs;
        FunctionProgramBlock fpb;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Executing instruction : " + this.toString()));
        }
        if (this._boundInputs.length < (fpb = ec.getProgram().getFunctionProgramBlock(this._namespace, this._functionName)).getInputParams().size()) {
            throw new DMLRuntimeException("Number of bound input parameters does not match the function signature (" + this._boundInputs.length + ", but " + fpb.getInputParams().size() + " expected)");
        }
        LineageItem[] lineageItemArray = liInputs = DMLScript.LINEAGE ? LineageItemUtils.getLineage(ec, this._boundInputs) : null;
        if (this.reuseFunctionOutputs(liInputs, fpb, ec)) {
            return;
        }
        LocalVariableMap functionVariables = new LocalVariableMap();
        Lineage lineage = DMLScript.LINEAGE ? new Lineage() : null;
        for (int i = 0; i < this._boundInputs.length; ++i) {
            void var10_13;
            CPOperand input = this._boundInputs[i];
            if (!input.isLiteral() && !ec.containsVariable(input.getName())) {
                throw new DMLRuntimeException("Input variable '" + input.getName() + "' not existing on call of " + DMLProgram.constructFunctionKey(this._namespace, this._functionName) + " (line " + this.getLineNum() + ").");
            }
            String argName = this._funArgNames.get(i);
            DataIdentifier currFormalParam = fpb.getInputParam(argName);
            if (currFormalParam == null) {
                throw new DMLRuntimeException("Non-existing named function argument: '" + argName + "' (line " + this.getLineNum() + ").");
            }
            Data data = ec.getVariable(input);
            if (data.getDataType() == Types.DataType.SCALAR && data.getValueType() != currFormalParam.getValueType()) {
                ScalarObject scalarObject = ScalarObjectFactory.createScalarObject(currFormalParam.getValueType(), (ScalarObject)data);
            }
            functionVariables.put(currFormalParam.getName(), (Data)var10_13);
            if (lineage == null) continue;
            lineage.set(currFormalParam.getName(), ec.getLineageItem(input));
        }
        boolean[] pinStatus = ec.pinVariables(this._boundInputNames);
        ExecutionContext fn_ec = ExecutionContextFactory.createContext(false, false, ec.getProgram());
        if (DMLScript.USE_ACCELERATOR) {
            fn_ec.setGPUContexts(ec.getGPUContexts());
            fn_ec.getGPUContext(0).initializeThread();
        }
        fn_ec.setVariables(functionVariables);
        fn_ec.setLineage(lineage);
        try {
            fpb._functionName = this._functionName;
            fpb._namespace = this._namespace;
            fpb.execute(fn_ec);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            String fname = DMLProgram.constructFunctionKey(this._namespace, this._functionName);
            throw new DMLRuntimeException("error executing function " + (String)fname, e);
        }
        HashSet<String> expectRetVars = new HashSet<String>();
        for (DataIdentifier dataIdentifier : fpb.getOutputParams()) {
            expectRetVars.add(dataIdentifier.getName());
        }
        LocalVariableMap retVars = fn_ec.getVariables();
        for (String varName : new ArrayList<String>(retVars.keySet())) {
            if (expectRetVars.contains(varName)) continue;
            fn_ec.cleanupDataObject(fn_ec.removeVariable(varName));
        }
        ec.unpinVariables(this._boundInputNames, pinStatus);
        int n = Math.min(this._boundOutputNames.size(), fpb.getOutputParams().size());
        for (int i = 0; i < n; ++i) {
            String boundVarName = this._boundOutputNames.get(i);
            String retVarName = fpb.getOutputParams().get(i).getName();
            Data boundValue = retVars.get(retVarName);
            if (boundValue == null) {
                throw new DMLRuntimeException(boundVarName + " was not assigned a return value");
            }
            Data exdata = ec.removeVariable(boundVarName);
            if (exdata != boundValue) {
                ec.cleanupDataObject(exdata);
            }
            ec.setVariable(boundVarName, boundValue);
            if (lineage == null) continue;
            ec.getLineage().set(boundVarName, lineage.get(retVarName));
        }
        LineageCache.putValue(this._boundOutputNames, n, liInputs, this._functionName, ec);
    }

    @Override
    public void postprocessInstruction(ExecutionContext ec) {
        super.postprocessInstruction(ec);
    }

    @Override
    public void printMe() {
        LOG.debug((Object)("ExternalBuiltInFunction: " + this.toString()));
    }

    public List<String> getBoundOutputParamNames() {
        return this._boundOutputNames;
    }

    public String updateInstStringFunctionName(String pattern, String replace) {
        String[] parts = this.instString.split("\u00b0");
        if (parts[3].equals(pattern)) {
            parts[3] = replace;
        }
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
            sb.append("\u00b0");
        }
        return sb.substring(0, sb.length() - "\u00b0".length());
    }

    private boolean reuseFunctionOutputs(LineageItem[] liInputs, FunctionProgramBlock fpb, ExecutionContext ec) {
        int numOutputs = Math.min(this._boundOutputNames.size(), fpb.getOutputParams().size());
        boolean reuse = LineageCache.reuse(this._boundOutputNames, numOutputs, liInputs, this._functionName, ec);
        if (reuse && DMLScript.STATISTICS) {
            Statistics.maintainCPFuncCallStats(this.getExtendedOpcode());
            LineageCacheStatistics.incrementFuncHits();
        }
        return reuse;
    }
}

