/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.Arrays;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.rewrite.ProgramRewriter;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DMLTranslator;
import org.tugraz.sysds.parser.FunctionStatementBlock;
import org.tugraz.sysds.parser.dml.DmlSyntacticValidator;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.caching.FrameObject;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.util.DataConverter;

public class EvalNaryCPInstruction
extends BuiltinNaryCPInstruction {
    public EvalNaryCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String funcName = ec.getScalarInput(this.inputs[0]).getStringValue();
        if (funcName.contains("::")) {
            throw new DMLRuntimeException("Eval calls to '" + funcName + "', i.e., a function outside the default namespace, are not supported yet. Please call the function directly.");
        }
        CPOperand[] boundInputs = Arrays.copyOfRange(this.inputs, 1, this.inputs.length);
        ArrayList<String> boundOutputNames = new ArrayList<String>();
        boundOutputNames.add(this.output.getName());
        ArrayList<String> boundInputNames = new ArrayList<String>();
        for (CPOperand input : boundInputs) {
            boundInputNames.add(input.getName());
        }
        MatrixObject outputMO = new MatrixObject(ec.getMatrixObject(this.output.getName()));
        if (!ec.getProgram().containsFunctionProgramBlock(null, funcName)) {
            FunctionProgramBlock fpb = EvalNaryCPInstruction.compileFunctionProgramBlock(funcName, boundInputs[0].getDataType(), ec.getProgram());
            ec.getProgram().addFunctionProgramBlock(null, funcName, fpb);
        }
        FunctionProgramBlock fpb = ec.getProgram().getFunctionProgramBlock(null, funcName);
        FunctionCallCPInstruction fcpi = new FunctionCallCPInstruction(null, funcName, boundInputs, boundInputNames, fpb.getInputParamNames(), boundOutputNames, "eval func");
        fcpi.processInstruction(ec);
        Data newOutput = ec.getVariable(this.output);
        if (newOutput instanceof MatrixObject) {
            return;
        }
        MatrixBlock mb = null;
        if (newOutput instanceof ScalarObject) {
            mb = new MatrixBlock(((ScalarObject)newOutput).getDoubleValue());
        } else if (newOutput instanceof FrameObject) {
            mb = DataConverter.convertToMatrixBlock((FrameBlock)((FrameObject)newOutput).acquireRead());
            ec.cleanupCacheableData((FrameObject)newOutput);
        }
        outputMO.acquireModify(mb);
        outputMO.release();
        ec.setVariable(this.output.getName(), outputMO);
    }

    private static FunctionProgramBlock compileFunctionProgramBlock(String name, Types.DataType dt, Program prog) {
        FunctionStatementBlock fsb = DmlSyntacticValidator.loadAndParseBuiltinFunction(name, ".defaultNS", dt);
        DMLProgram dmlp = fsb.getDMLProg();
        DMLTranslator dmlt = new DMLTranslator(dmlp);
        dmlt.liveVariableAnalysisFunction(dmlp, fsb);
        dmlt.validateFunction(dmlp, fsb);
        dmlt.constructHops(fsb);
        ProgramRewriter rewriter = new ProgramRewriter(true, false);
        rewriter.rewriteHopDAGsFunction(fsb, false);
        DMLTranslator.resetHopsDAGVisitStatus(fsb);
        rewriter.rewriteHopDAGsFunction(fsb, true);
        DMLTranslator.resetHopsDAGVisitStatus(fsb);
        ProgramRewriter rewriter2 = new ProgramRewriter(false, true);
        rewriter2.rewriteHopDAGsFunction(fsb, true);
        DMLTranslator.resetHopsDAGVisitStatus(fsb);
        DMLTranslator.refreshMemEstimates(fsb);
        dmlt.constructLops(fsb);
        return (FunctionProgramBlock)dmlt.createRuntimeProgramBlock(prog, fsb, ConfigurationManager.getDMLConfig());
    }
}

