/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.COV;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CM_COV_Object;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.COVOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class CovarianceCPInstruction
extends BinaryCPInstruction {
    private CovarianceCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.AggregateBinary, op, in1, in2, out, opcode, istr);
    }

    private CovarianceCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.AggregateBinary, op, in1, in2, in3, out, opcode, istr);
    }

    public static CovarianceCPInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cov")) {
            throw new DMLRuntimeException("CovarianceCPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        COVOperator cov = new COVOperator(COV.getCOMFnObject());
        if (parts.length == 4) {
            CovarianceCPInstruction.parseBinaryInstruction(str, in1, in2, out);
            return new CovarianceCPInstruction(cov, in1, in2, out, opcode, str);
        }
        if (parts.length == 5) {
            in3 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CovarianceCPInstruction.parseBinaryInstruction(str, in1, in2, in3, out);
            return new CovarianceCPInstruction(cov, in1, in2, in3, out, opcode, str);
        }
        throw new DMLRuntimeException("Invalid number of arguments in Instruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        String output_name = this.output.getName();
        COVOperator cov_op = (COVOperator)this._optr;
        CM_COV_Object covobj = new CM_COV_Object();
        if (this.input3 == null) {
            covobj = matBlock1.covOperations(cov_op, matBlock2);
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        } else {
            MatrixBlock wtBlock = ec.getMatrixInput(this.input3.getName());
            covobj = matBlock1.covOperations(cov_op, matBlock2, wtBlock);
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName(), this.input3.getName());
        }
        double val = covobj.getRequiredResult(this._optr);
        ec.setScalarOutput(output_name, new DoubleObject(val));
    }
}

