/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObjectFactory;

public class CPOperand {
    private String _name;
    private Types.ValueType _valueType;
    private Types.DataType _dataType;
    private boolean _isLiteral;
    private ScalarObject _literal;

    public CPOperand() {
        this("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
    }

    public CPOperand(String str) {
        this("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        this.split(str);
    }

    public CPOperand(String name, Types.ValueType vt, Types.DataType dt) {
        this(name, vt, dt, false);
    }

    public CPOperand(String name, Types.ValueType vt, Types.DataType dt, boolean literal) {
        this._name = name;
        this._valueType = vt;
        this._dataType = dt;
        this._isLiteral = literal;
    }

    public CPOperand(ScalarObject so) {
        this._name = so.getStringValue();
        this._valueType = so.getValueType();
        this._dataType = Types.DataType.SCALAR;
        this._isLiteral = true;
    }

    public CPOperand(CPOperand variable) {
        this._name = variable._name;
        this._valueType = variable._valueType;
        this._dataType = variable._dataType;
        this._isLiteral = variable._isLiteral;
        this._literal = variable._literal;
    }

    public String getName() {
        return this._name;
    }

    public Types.ValueType getValueType() {
        return this._valueType;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public boolean isMatrix() {
        return this._dataType.isMatrix();
    }

    public boolean isTensor() {
        return this._dataType.isTensor();
    }

    public boolean isList() {
        return this._dataType.isList();
    }

    public boolean isScalar() {
        return this._dataType.isScalar();
    }

    public boolean isLiteral() {
        return this._isLiteral;
    }

    public ScalarObject getLiteral() {
        if (!this._isLiteral) {
            throw new DMLRuntimeException("CPOperand is not a literal.");
        }
        if (this._literal == null) {
            this._literal = ScalarObjectFactory.createScalarObject(this._valueType, this._name);
        }
        return this._literal;
    }

    public void setName(String name) {
        this._name = name;
        this._literal = null;
    }

    public void setLiteral(ScalarObject literal) {
        this._name = String.valueOf(literal);
        this._literal = literal;
        this._isLiteral = this._literal != null;
    }

    public void split(String str) {
        String[] opr = str.split("\u00b7");
        if (opr.length == 4) {
            this._name = opr[0];
            this._dataType = Types.DataType.valueOf(opr[1]);
            this._valueType = Types.ValueType.valueOf(opr[2]);
            this._isLiteral = Boolean.parseBoolean(opr[3]);
        } else if (opr.length == 3) {
            this._name = opr[0];
            this._dataType = Types.DataType.valueOf(opr[1]);
            this._valueType = Types.ValueType.valueOf(opr[2]);
            this._isLiteral = false;
        } else if (opr.length == 1) {
            this._name = opr[0];
            this._dataType = Types.DataType.SCALAR;
            this._valueType = Types.ValueType.FP64;
            this._isLiteral = true;
        } else {
            this._name = opr[0];
            this._valueType = Types.ValueType.valueOf(opr[1]);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getLineageLiteral() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\u00b7");
        sb.append(this.getDataType().toString());
        sb.append("\u00b7");
        sb.append(this.getValueType().toString());
        sb.append("\u00b7");
        sb.append(this.isLiteral());
        return sb.toString();
    }

    public String getLineageLiteral(ScalarObject so) {
        StringBuilder sb = new StringBuilder(so.toString());
        sb.append("\u00b7");
        sb.append(this.getDataType().toString());
        sb.append("\u00b7");
        sb.append(this.getValueType().toString());
        sb.append("\u00b7");
        sb.append(this.isLiteral());
        return sb.toString();
    }
}

