/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;

public class BooleanObject
extends ScalarObject {
    private static final long serialVersionUID = -4506242165735516984L;
    private final boolean _value;

    public BooleanObject(boolean val) {
        super(Types.ValueType.BOOLEAN);
        this._value = val;
    }

    @Override
    public boolean getBooleanValue() {
        return this._value;
    }

    @Override
    public long getLongValue() {
        return this._value ? 1L : 0L;
    }

    @Override
    public double getDoubleValue() {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this._value).toUpperCase();
    }

    @Override
    public String getLanguageSpecificStringValue() {
        return Boolean.toString(this._value).toUpperCase();
    }

    @Override
    public Object getValue() {
        return this._value;
    }
}

