/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.matrix.data.LibCommonsMath;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class BinaryMatrixMatrixCPInstruction
extends BinaryCPInstruction {
    protected BinaryMatrixMatrixCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (LibCommonsMath.isSupportedMatrixMatrixOperation(this.getOpcode())) {
            MatrixBlock solution = LibCommonsMath.matrixMatrixOperations(ec.getMatrixInput(this.input1.getName()), ec.getMatrixInput(this.input2.getName()), this.getOpcode());
            ec.setMatrixOutput(this.output.getName(), solution);
            ec.releaseMatrixInput(this.input1.getName());
            ec.releaseMatrixInput(this.input2.getName());
            return;
        }
        MatrixBlock inBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock inBlock2 = ec.getMatrixInput(this.input2.getName());
        BinaryOperator bop = (BinaryOperator)this._optr;
        MatrixBlock retBlock = inBlock1.binaryOperations(bop, inBlock2, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        if (this.checkGuardedRepresentationChange(inBlock1, inBlock2, retBlock)) {
            retBlock.examSparsity();
        }
        ec.setMatrixOutput(this.output.getName(), retBlock);
    }
}

