/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions;

import java.util.StringTokenizer;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.BinaryM;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.functionobjects.And;
import org.tugraz.sysds.runtime.functionobjects.BitwAnd;
import org.tugraz.sysds.runtime.functionobjects.BitwOr;
import org.tugraz.sysds.runtime.functionobjects.BitwShiftL;
import org.tugraz.sysds.runtime.functionobjects.BitwShiftR;
import org.tugraz.sysds.runtime.functionobjects.BitwXor;
import org.tugraz.sysds.runtime.functionobjects.Builtin;
import org.tugraz.sysds.runtime.functionobjects.CM;
import org.tugraz.sysds.runtime.functionobjects.Divide;
import org.tugraz.sysds.runtime.functionobjects.Equals;
import org.tugraz.sysds.runtime.functionobjects.GreaterThan;
import org.tugraz.sysds.runtime.functionobjects.GreaterThanEquals;
import org.tugraz.sysds.runtime.functionobjects.IfElse;
import org.tugraz.sysds.runtime.functionobjects.IndexFunction;
import org.tugraz.sysds.runtime.functionobjects.IntegerDivide;
import org.tugraz.sysds.runtime.functionobjects.KahanPlus;
import org.tugraz.sysds.runtime.functionobjects.KahanPlusSq;
import org.tugraz.sysds.runtime.functionobjects.LessThan;
import org.tugraz.sysds.runtime.functionobjects.LessThanEquals;
import org.tugraz.sysds.runtime.functionobjects.Mean;
import org.tugraz.sysds.runtime.functionobjects.Minus;
import org.tugraz.sysds.runtime.functionobjects.Minus1Multiply;
import org.tugraz.sysds.runtime.functionobjects.MinusMultiply;
import org.tugraz.sysds.runtime.functionobjects.MinusNz;
import org.tugraz.sysds.runtime.functionobjects.Modulus;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.Multiply2;
import org.tugraz.sysds.runtime.functionobjects.Not;
import org.tugraz.sysds.runtime.functionobjects.NotEquals;
import org.tugraz.sysds.runtime.functionobjects.Or;
import org.tugraz.sysds.runtime.functionobjects.Plus;
import org.tugraz.sysds.runtime.functionobjects.PlusMultiply;
import org.tugraz.sysds.runtime.functionobjects.Power;
import org.tugraz.sysds.runtime.functionobjects.Power2;
import org.tugraz.sysds.runtime.functionobjects.ReduceAll;
import org.tugraz.sysds.runtime.functionobjects.ReduceCol;
import org.tugraz.sysds.runtime.functionobjects.ReduceDiag;
import org.tugraz.sysds.runtime.functionobjects.ReduceRow;
import org.tugraz.sysds.runtime.functionobjects.Xor;
import org.tugraz.sysds.runtime.instructions.CPInstructionParser;
import org.tugraz.sysds.runtime.instructions.FEDInstructionParser;
import org.tugraz.sysds.runtime.instructions.GPUInstructionParser;
import org.tugraz.sysds.runtime.instructions.SPInstructionParser;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibCommonsMath;
import org.tugraz.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.CMOperator;
import org.tugraz.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.RightScalarOperator;
import org.tugraz.sysds.runtime.matrix.operators.ScalarOperator;
import org.tugraz.sysds.runtime.matrix.operators.TernaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.UnaryOperator;

public class InstructionUtils {
    public static int checkNumFields(String str, int expected) {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected) {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected1, int expected2) {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String str, int expected1, int expected2) {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static String[] getInstructionParts(String str) {
        StringTokenizer st = new StringTokenizer(str, "\u00b0");
        String[] ret = new String[st.countTokens() - 1];
        st.nextToken();
        ret[0] = st.nextToken();
        int index = 1;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            int ix = tmp.indexOf("\u00b7");
            ret[index++] = tmp.substring(0, ix >= 0 ? ix : tmp.length());
        }
        return ret;
    }

    public static String[] getInstructionPartsWithValueType(String str) {
        String[] parts = str.split("\u00b0", -1);
        String[] ret = new String[parts.length - 1];
        ret[0] = parts[1];
        for (int i = 1; i < parts.length; ++i) {
            ret[i - 1] = parts[i];
        }
        return ret;
    }

    public static LopProperties.ExecType getExecType(String str) {
        int ix = str.indexOf("\u00b0");
        return LopProperties.ExecType.valueOf(str.substring(0, ix));
    }

    public static String getOpCode(String str) {
        int ix1 = str.indexOf("\u00b0");
        int ix2 = str.indexOf("\u00b0", ix1 + 1);
        return str.substring(ix1 + 1, ix2);
    }

    public static SPInstruction.SPType getSPType(String str) {
        return SPInstructionParser.String2SPInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static CPInstruction.CPType getCPType(String str) {
        return CPInstructionParser.String2CPInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static SPInstruction.SPType getSPTypeByOpcode(String opcode) {
        return SPInstructionParser.String2SPInstructionType.get(opcode);
    }

    public static CPInstruction.CPType getCPTypeByOpcode(String opcode) {
        return CPInstructionParser.String2CPInstructionType.get(opcode);
    }

    public static GPUInstruction.GPUINSTRUCTION_TYPE getGPUType(String str) {
        return GPUInstructionParser.String2GPUInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static FEDInstruction.FEDType getFEDType(String str) {
        return FEDInstructionParser.String2FEDInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static boolean isBuiltinFunction(String opcode) {
        Builtin.BuiltinCode bfc = Builtin.String2BuiltinCode.get(opcode);
        return bfc != null;
    }

    public static boolean isDistributedCacheUsed(String str) {
        String[] parts;
        for (String inst : parts = str.split("\u2021")) {
            String opcode = InstructionUtils.getOpCode(inst);
            if (!opcode.equalsIgnoreCase("mappend") && !opcode.equalsIgnoreCase("mapmm") && !opcode.equalsIgnoreCase("mapmmchain") && !opcode.equalsIgnoreCase("pmm") && !opcode.equalsIgnoreCase("uaggouterchain") && !opcode.equalsIgnoreCase("mapgroupedagg") && !InstructionUtils.isDistQuaternaryOpcode(opcode) && !BinaryM.isOpcode(opcode)) continue;
            return true;
        }
        return false;
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode) {
        return InstructionUtils.parseBasicAggregateUnaryOperator(opcode, 1);
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode, int numThreads) {
        AggregateUnaryOperator aggun = null;
        if (opcode.equalsIgnoreCase("uak+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uark+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uack+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uasqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarsqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacsqk+")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmean")) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOROWS);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uavar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarvar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacvar")) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURROWS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("ua+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uar+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uac+")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("ua*")) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uar*")) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uac*")) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamax")) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uamin")) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uatrace")) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uaktrace")) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmax")) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarimax")) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("maxindex"), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarmin")) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uarimin")) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("minindex"), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmax")) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase("uacmin")) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        }
        return aggun;
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode) {
        return InstructionUtils.parseAggregateTernaryOperator(opcode, 1);
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode, int numThreads) {
        Types.CorrectionLocationType corr = opcode.equalsIgnoreCase("tak+*") ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.LASTROW;
        AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), corr);
        IndexFunction ixfun = opcode.equalsIgnoreCase("tak+*") ? ReduceAll.getReduceAllFnObject() : ReduceRow.getReduceRowFnObject();
        return new AggregateTernaryOperator(Multiply.getMultiplyFnObject(), agg, ixfun, numThreads);
    }

    public static AggregateOperator parseAggregateOperator(String opcode, String corrLoc) {
        AggregateOperator agg = null;
        if (opcode.equalsIgnoreCase("ak+") || opcode.equalsIgnoreCase("aktrace")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("asqk+")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("a+")) {
            agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        } else if (opcode.equalsIgnoreCase("a*")) {
            agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
        } else if (opcode.equalsIgnoreCase("arimax")) {
            agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("maxindex"), Types.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amax")) {
            agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
        } else if (opcode.equalsIgnoreCase("amin")) {
            agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
        } else if (opcode.equalsIgnoreCase("arimin")) {
            agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("minindex"), Types.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amean")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTTWOCOLUMNS : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("avar")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTFOURCOLUMNS : Types.CorrectionLocationType.valueOf(corrLoc);
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            agg = new AggregateOperator(0.0, varFn, lcorrLoc);
        }
        return agg;
    }

    public static AggregateUnaryOperator parseBasicCumulativeAggregateUnaryOperator(UnaryOperator uop) {
        Builtin f = (Builtin)uop.fn;
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMSUM) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uack+");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMPROD) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uac*");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMIN) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uacmin");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMAX) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uacmax");
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMSUMPROD) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uack+*");
        }
        throw new RuntimeException("Unsupported cumulative aggregate unary operator: " + (Object)((Object)f.getBuiltinCode()));
    }

    public static AggregateUnaryOperator parseCumulativeAggregateUnaryOperator(String opcode) {
        AggregateOperator agg = null;
        if ("ucumack+".equals(opcode)) {
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTROW);
        } else if ("ucumac*".equals(opcode)) {
            agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject(), Types.CorrectionLocationType.NONE);
        } else if ("ucumac+*".equals(opcode)) {
            agg = new AggregateOperator(0.0, PlusMultiply.getFnObject(), Types.CorrectionLocationType.NONE);
        } else if ("ucumacmin".equals(opcode)) {
            agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("min"), Types.CorrectionLocationType.NONE);
        } else if ("ucumacmax".equals(opcode)) {
            agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("max"), Types.CorrectionLocationType.NONE);
        }
        return new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
    }

    public static UnaryOperator parseUnaryOperator(String opcode) {
        return opcode.equals("!") ? new UnaryOperator(Not.getNotFnObject()) : new UnaryOperator(Builtin.getBuiltinFnObject(opcode));
    }

    public static Operator parseBinaryOrBuiltinOperator(String opcode, CPOperand in1, CPOperand in2) {
        boolean matrixScalar;
        if (LibCommonsMath.isSupportedMatrixMatrixOperation(opcode)) {
            return null;
        }
        boolean bl = matrixScalar = in1.getDataType() != in2.getDataType();
        return Builtin.isBuiltinFnObject(opcode) ? (matrixScalar ? new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), 0.0) : new BinaryOperator(Builtin.getBuiltinFnObject(opcode))) : (matrixScalar ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType().isScalar()) : InstructionUtils.parseBinaryOperator(opcode));
    }

    public static Operator parseExtendedBinaryOrBuiltinOperator(String opcode, CPOperand in1, CPOperand in2) {
        boolean matrixScalar;
        boolean bl = matrixScalar = in1.getDataType() != in2.getDataType();
        return Builtin.isBuiltinFnObject(opcode) ? (matrixScalar ? new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), 0.0) : new BinaryOperator(Builtin.getBuiltinFnObject(opcode))) : (matrixScalar ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType().isScalar()) : InstructionUtils.parseExtendedBinaryOperator(opcode));
    }

    public static BinaryOperator parseBinaryOperator(String opcode) {
        if (opcode.equalsIgnoreCase("==")) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("!=")) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("<")) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(">")) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase("<=")) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(">=")) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("&&")) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase("||")) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase("xor")) {
            return new BinaryOperator(Xor.getXorFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwAnd")) {
            return new BinaryOperator(BitwAnd.getBitwAndFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwOr")) {
            return new BinaryOperator(BitwOr.getBitwOrFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwXor")) {
            return new BinaryOperator(BitwXor.getBitwXorFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwShiftL")) {
            return new BinaryOperator(BitwShiftL.getBitwShiftLFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwShiftR")) {
            return new BinaryOperator(BitwShiftR.getBitwShiftRFnObject());
        }
        if (opcode.equalsIgnoreCase("+")) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase("-")) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase("*")) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("1-*")) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase("/")) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase("%%")) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase("%/%")) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase("^")) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase("max")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase("min")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        throw new RuntimeException("Unknown binary opcode " + opcode);
    }

    public static TernaryOperator parseTernaryOperator(String opcode) {
        return new TernaryOperator(opcode.equals("+*") ? PlusMultiply.getFnObject() : (opcode.equals("-*") ? MinusMultiply.getFnObject() : IfElse.getFnObject()));
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar) {
        double default_constant = 0.0;
        return InstructionUtils.parseScalarBinaryOperator(opcode, arg1IsScalar, default_constant);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar, double constant) {
        if (opcode.equalsIgnoreCase("+")) {
            return new RightScalarOperator(Plus.getPlusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("*")) {
            return new RightScalarOperator(Multiply.getMultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("-")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
            }
            return new RightScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("-nz")) {
            return new RightScalarOperator(MinusNz.getMinusNzFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("/")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
            }
            return new RightScalarOperator(Divide.getDivideFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("%%")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Modulus.getFnObject(), constant);
            }
            return new RightScalarOperator(Modulus.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("%/%")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(IntegerDivide.getFnObject(), constant);
            }
            return new RightScalarOperator(IntegerDivide.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("^")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Power.getPowerFnObject(), constant);
            }
            return new RightScalarOperator(Power.getPowerFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("max")) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("max"), constant);
        }
        if (opcode.equalsIgnoreCase("min")) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("min"), constant);
        }
        if (opcode.equalsIgnoreCase("log") || opcode.equalsIgnoreCase("log_nz")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
            }
            return new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
        }
        if (opcode.equalsIgnoreCase(">")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(">=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("<")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThan.getLessThanFnObject(), constant);
            }
            return new RightScalarOperator(LessThan.getLessThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("<=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("==")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Equals.getEqualsFnObject(), constant);
            }
            return new RightScalarOperator(Equals.getEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("!=")) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
            }
            return new RightScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("&&")) {
            return arg1IsScalar ? new LeftScalarOperator(And.getAndFnObject(), constant) : new RightScalarOperator(And.getAndFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("||")) {
            return arg1IsScalar ? new LeftScalarOperator(Or.getOrFnObject(), constant) : new RightScalarOperator(Or.getOrFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("xor")) {
            return arg1IsScalar ? new LeftScalarOperator(Xor.getXorFnObject(), constant) : new RightScalarOperator(Xor.getXorFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("bitwAnd")) {
            return arg1IsScalar ? new LeftScalarOperator(BitwAnd.getBitwAndFnObject(), constant) : new RightScalarOperator(BitwAnd.getBitwAndFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("bitwOr")) {
            return arg1IsScalar ? new LeftScalarOperator(BitwOr.getBitwOrFnObject(), constant) : new RightScalarOperator(BitwOr.getBitwOrFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("bitwXor")) {
            return arg1IsScalar ? new LeftScalarOperator(BitwXor.getBitwXorFnObject(), constant) : new RightScalarOperator(BitwXor.getBitwXorFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("bitwShiftL")) {
            return arg1IsScalar ? new LeftScalarOperator(BitwShiftL.getBitwShiftLFnObject(), constant) : new RightScalarOperator(BitwShiftL.getBitwShiftLFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("bitwShiftR")) {
            return arg1IsScalar ? new LeftScalarOperator(BitwShiftR.getBitwShiftRFnObject(), constant) : new RightScalarOperator(BitwShiftR.getBitwShiftRFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new RightScalarOperator(Multiply2.getMultiply2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new RightScalarOperator(Power2.getPower2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("1-*")) {
            return new RightScalarOperator(Minus1Multiply.getMinus1MultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("s-r")) {
            return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("so")) {
            return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
        }
        throw new RuntimeException("Unknown binary opcode " + opcode);
    }

    public static BinaryOperator parseExtendedBinaryOperator(String opcode) {
        if (opcode.equalsIgnoreCase("==") || opcode.equalsIgnoreCase("map==")) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("!=") || opcode.equalsIgnoreCase("map!=")) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("<") || opcode.equalsIgnoreCase("map<")) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(">") || opcode.equalsIgnoreCase("map>")) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase("<=") || opcode.equalsIgnoreCase("map<=")) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(">=") || opcode.equalsIgnoreCase("map>=")) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase("&&") || opcode.equalsIgnoreCase("map&&")) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase("||") || opcode.equalsIgnoreCase("map||")) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase("xor") || opcode.equalsIgnoreCase("mapxor")) {
            return new BinaryOperator(Xor.getXorFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwAnd") || opcode.equalsIgnoreCase("mapbitwAnd")) {
            return new BinaryOperator(BitwAnd.getBitwAndFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwOr") || opcode.equalsIgnoreCase("mapbitwOr")) {
            return new BinaryOperator(BitwOr.getBitwOrFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwXor") || opcode.equalsIgnoreCase("mapbitwXor")) {
            return new BinaryOperator(BitwXor.getBitwXorFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwShiftL") || opcode.equalsIgnoreCase("mapbitwShiftL")) {
            return new BinaryOperator(BitwShiftL.getBitwShiftLFnObject());
        }
        if (opcode.equalsIgnoreCase("bitwShiftR") || opcode.equalsIgnoreCase("mapbitwShiftR")) {
            return new BinaryOperator(BitwShiftR.getBitwShiftRFnObject());
        }
        if (opcode.equalsIgnoreCase("+") || opcode.equalsIgnoreCase("map+")) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase("-") || opcode.equalsIgnoreCase("map-")) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase("*") || opcode.equalsIgnoreCase("map*")) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("1-*") || opcode.equalsIgnoreCase("map1-*")) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase("*2")) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase("/") || opcode.equalsIgnoreCase("map/")) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase("%%") || opcode.equalsIgnoreCase("map%%")) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase("%/%") || opcode.equalsIgnoreCase("map%/%")) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase("^") || opcode.equalsIgnoreCase("map^")) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase("^2")) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase("max") || opcode.equalsIgnoreCase("mapmax")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase("min") || opcode.equalsIgnoreCase("mapmin")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        throw new DMLRuntimeException("Unknown binary opcode " + opcode);
    }

    public static String deriveAggregateOperatorOpcode(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "uark+": 
            case "uack+": {
                return "ak+";
            }
            case "ua+": 
            case "uar+": 
            case "uac+": {
                return "a+";
            }
            case "uatrace": 
            case "uaktrace": {
                return "aktrace";
            }
            case "uasqk+": 
            case "uarsqk+": 
            case "uacsqk+": {
                return "asqk+";
            }
            case "uamean": 
            case "uarmean": 
            case "uacmean": {
                return "amean";
            }
            case "uavar": 
            case "uarvar": 
            case "uacvar": {
                return "avar";
            }
            case "ua*": 
            case "uar*": 
            case "uac*": {
                return "a*";
            }
            case "uamax": 
            case "uarmax": 
            case "uacmax": {
                return "amax";
            }
            case "uamin": 
            case "uarmin": 
            case "uacmin": {
                return "amin";
            }
            case "uarimax": {
                return "arimax";
            }
            case "uarimin": {
                return "arimin";
            }
        }
        return null;
    }

    public static Types.AggOp getAggOp(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "uark+": 
            case "uack+": 
            case "ua+": 
            case "uar+": 
            case "uac+": 
            case "uatrace": 
            case "uaktrace": {
                return Types.AggOp.SUM;
            }
            case "uasqk+": 
            case "uarsqk+": 
            case "uacsqk+": {
                return Types.AggOp.SUM_SQ;
            }
            case "uamean": 
            case "uarmean": 
            case "uacmean": {
                return Types.AggOp.MEAN;
            }
            case "uavar": 
            case "uarvar": 
            case "uacvar": {
                return Types.AggOp.VAR;
            }
            case "ua*": 
            case "uar*": 
            case "uac*": {
                return Types.AggOp.PROD;
            }
            case "uamax": 
            case "uarmax": 
            case "uacmax": {
                return Types.AggOp.MAX;
            }
            case "uamin": 
            case "uarmin": 
            case "uacmin": {
                return Types.AggOp.MIN;
            }
            case "uarimax": {
                return Types.AggOp.MAXINDEX;
            }
            case "uarimin": {
                return Types.AggOp.MININDEX;
            }
        }
        return null;
    }

    public static Types.Direction getAggDirection(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "ua+": 
            case "uatrace": 
            case "uaktrace": 
            case "uasqk+": 
            case "uamean": 
            case "uavar": 
            case "ua*": 
            case "uamax": 
            case "uamin": {
                return Types.Direction.RowCol;
            }
            case "uark+": 
            case "uar+": 
            case "uarsqk+": 
            case "uarmean": 
            case "uar*": 
            case "uarmax": 
            case "uarmin": 
            case "uarimax": 
            case "uarimin": {
                return Types.Direction.Row;
            }
            case "uack+": 
            case "uac+": 
            case "uacsqk+": 
            case "uacmean": 
            case "uarvar": 
            case "uacvar": 
            case "uac*": 
            case "uacmax": 
            case "uacmin": {
                return Types.Direction.Col;
            }
        }
        return null;
    }

    public static Types.CorrectionLocationType deriveAggregateOperatorCorrectionLocation(String opcode) {
        if (opcode.equalsIgnoreCase("uak+") || opcode.equalsIgnoreCase("uark+") || opcode.equalsIgnoreCase("uasqk+") || opcode.equalsIgnoreCase("uarsqk+") || opcode.equalsIgnoreCase("uatrace") || opcode.equalsIgnoreCase("uaktrace")) {
            return Types.CorrectionLocationType.LASTCOLUMN;
        }
        if (opcode.equalsIgnoreCase("uack+") || opcode.equalsIgnoreCase("uacsqk+")) {
            return Types.CorrectionLocationType.LASTROW;
        }
        if (opcode.equalsIgnoreCase("uamean") || opcode.equalsIgnoreCase("uarmean")) {
            return Types.CorrectionLocationType.LASTTWOCOLUMNS;
        }
        if (opcode.equalsIgnoreCase("uacmean")) {
            return Types.CorrectionLocationType.LASTTWOROWS;
        }
        if (opcode.equalsIgnoreCase("uavar") || opcode.equalsIgnoreCase("uarvar")) {
            return Types.CorrectionLocationType.LASTFOURCOLUMNS;
        }
        if (opcode.equalsIgnoreCase("uacvar")) {
            return Types.CorrectionLocationType.LASTFOURROWS;
        }
        if (opcode.equalsIgnoreCase("uarimax") || opcode.equalsIgnoreCase("uarimin")) {
            return Types.CorrectionLocationType.LASTCOLUMN;
        }
        return Types.CorrectionLocationType.NONE;
    }

    public static boolean isDistQuaternaryOpcode(String opcode) {
        return "mapwsloss".equalsIgnoreCase(opcode) || "redwsloss".equalsIgnoreCase(opcode) || "mapwsigmoid".equalsIgnoreCase(opcode) || "redwsigmoid".equalsIgnoreCase(opcode) || "mapwdivmm".equalsIgnoreCase(opcode) || "redwdivmm".equalsIgnoreCase(opcode) || "mapwcemm".equalsIgnoreCase(opcode) || "redwcemm".equalsIgnoreCase(opcode) || "mapwumm".equalsIgnoreCase(opcode) || "redwumm".equalsIgnoreCase(opcode);
    }

    public static AggregateBinaryOperator getMatMultOperator(int k) {
        AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        return new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg, k);
    }

    public static Operator parseGroupedAggOperator(String fn, String other) {
        CMOperator.AggregateOperationTypes op = CMOperator.AggregateOperationTypes.INVALID;
        op = fn.equalsIgnoreCase("centralmoment") ? CMOperator.getAggOpType(fn, other) : CMOperator.getAggOpType(fn, null);
        switch (op) {
            case SUM: {
                return new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            }
            case COUNT: 
            case MEAN: 
            case VARIANCE: 
            case CM2: 
            case CM3: 
            case CM4: {
                return new CMOperator(CM.getCMFnObject(op), op);
            }
        }
        throw new DMLRuntimeException("Invalid Aggregate Operation in GroupedAggregateInstruction: " + (Object)((Object)op));
    }

    public static String replaceOperand(String instStr, int operand, String newValue) {
        String[] parts = instStr.split("\u00b0");
        if (operand >= parts.length) {
            throw new DMLRuntimeException("Operand position " + operand + " exceeds the length of the instruction.");
        }
        parts[operand] = newValue;
        StringBuilder sb = new StringBuilder(instStr.length());
        sb.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            sb.append("\u00b0");
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static String concatOperands(String ... inputs) {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < inputs.length - 1; ++i) {
            sb.append(inputs[i]);
            sb.append("\u00b0");
        }
        sb.append(inputs[inputs.length - 1]);
        return sb.toString();
    }
}

