/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions;

import java.util.HashMap;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.instructions.InstructionParser;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.InitFEDInstruction;

public class FEDInstructionParser
extends InstructionParser {
    public static final HashMap<String, FEDInstruction.FEDType> String2FEDInstructionType = new HashMap();

    public static FEDInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        FEDInstruction.FEDType fedtype = InstructionUtils.getFEDType(str);
        if (fedtype == null) {
            throw new DMLRuntimeException("Unable derive fedtype for instruction: " + str);
        }
        FEDInstruction cpinst = FEDInstructionParser.parseSingleInstruction(fedtype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static FEDInstruction parseSingleInstruction(FEDInstruction.FEDType fedtype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (fedtype) {
            case Init: {
                return InitFEDInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryFEDInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid FEDERATED Instruction Type: " + (Object)((Object)fedtype));
    }

    static {
        String2FEDInstructionType.put("fedinit", FEDInstruction.FEDType.Init);
        String2FEDInstructionType.put("ba+*", FEDInstruction.FEDType.AggregateBinary);
    }
}

