/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.functionobjects;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.functionobjects.KahanPlus;
import org.tugraz.sysds.runtime.functionobjects.ValueFunction;
import org.tugraz.sysds.runtime.instructions.cp.CM_COV_Object;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.matrix.operators.CMOperator;

public class CM
extends ValueFunction {
    private static final long serialVersionUID = 9177194651533064123L;
    private CMOperator.AggregateOperationTypes _type = null;
    private KahanPlus _plus = null;
    private KahanObject _buff2 = null;
    private KahanObject _buff3 = null;

    private CM(CMOperator.AggregateOperationTypes type) {
        this._type = type;
        switch (this._type) {
            case COUNT: {
                break;
            }
            case CM4: 
            case CM3: {
                this._buff3 = new KahanObject(0.0, 0.0);
            }
            case CM2: {
                this._buff2 = new KahanObject(0.0, 0.0);
            }
            case VARIANCE: 
            case MEAN: {
                this._plus = KahanPlus.getKahanPlusFnObject();
                break;
            }
        }
    }

    public static CM getCMFnObject(CMOperator.AggregateOperationTypes type) {
        return new CM(type);
    }

    public CMOperator.AggregateOperationTypes getAggOpType() {
        return this._type;
    }

    @Override
    public Data execute(Data in1, double in2) {
        CM_COV_Object cm1 = (CM_COV_Object)in1;
        if (cm1.isCMAllZeros()) {
            cm1.w = 1.0;
            cm1.mean.set(in2, 0.0);
            cm1.m2.set(0.0, 0.0);
            cm1.m3.set(0.0, 0.0);
            cm1.m4.set(0.0, 0.0);
            return cm1;
        }
        switch (this._type) {
            case COUNT: {
                cm1.w += 1.0;
                break;
            }
            case MEAN: {
                double w = cm1.w + 1.0;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, d / w);
                cm1.w = w;
                break;
            }
            case CM2: {
                double w = cm1.w + 1.0;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, d / w);
                double t1 = cm1.w / w * d;
                double lt1 = t1 * d;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                cm1.m2.set(this._buff2);
                cm1.w = w;
                break;
            }
            case CM3: {
                double w = cm1.w + 1.0;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, d / w);
                double t1 = cm1.w / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 - Math.pow(t2, 2.0));
                double f2 = 1.0 / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, lt2 - 3.0 * cm1.m2._sum * f2 * d);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case CM4: {
                double w = cm1.w + 1.0;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, d / w);
                double t1 = cm1.w / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 - Math.pow(t2, 2.0));
                double lt3 = Math.pow(t1, 4.0) * (1.0 - Math.pow(t2, 3.0));
                double f2 = 1.0 / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, lt2 - 3.0 * cm1.m2._sum * f2 * d);
                cm1.m4 = (KahanObject)this._plus.execute((Data)cm1.m4, 6.0 * cm1.m2._sum * Math.pow(-f2 * d, 2.0) + lt3 - 4.0 * cm1.m3._sum * f2 * d);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case VARIANCE: {
                double w = cm1.w + 1.0;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, d / w);
                double t1 = cm1.w / w * d;
                double lt1 = t1 * d;
                cm1.m2 = (KahanObject)this._plus.execute((Data)cm1.m2, lt1);
                cm1.w = w;
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported operation type: " + (Object)((Object)this._type));
            }
        }
        return cm1;
    }

    @Override
    public Data execute(Data in1, double in2, double w2) {
        CM_COV_Object cm1 = (CM_COV_Object)in1;
        if (cm1.isCMAllZeros()) {
            cm1.w = w2;
            cm1.mean.set(in2, 0.0);
            cm1.m2.set(0.0, 0.0);
            cm1.m3.set(0.0, 0.0);
            cm1.m4.set(0.0, 0.0);
            return cm1;
        }
        switch (this._type) {
            case COUNT: {
                cm1.w = Math.round(cm1.w + w2);
                break;
            }
            case MEAN: {
                double w = cm1.w + w2;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, w2 * d / w);
                cm1.w = w;
                break;
            }
            case CM2: {
                double w = cm1.w + w2;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, w2 * d / w);
                double t1 = cm1.w * w2 / w * d;
                double lt1 = t1 * d;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                cm1.m2.set(this._buff2);
                cm1.w = w;
                break;
            }
            case CM3: {
                double w = cm1.w + w2;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, w2 * d / w);
                double t1 = cm1.w * w2 / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 / Math.pow(w2, 2.0) - Math.pow(t2, 2.0));
                double f2 = w2 / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, lt2 - 3.0 * cm1.m2._sum * f2 * d);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case CM4: {
                double w = cm1.w + w2;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, w2 * d / w);
                double t1 = cm1.w * w2 / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 / Math.pow(w2, 2.0) - Math.pow(t2, 2.0));
                double lt3 = Math.pow(t1, 4.0) * (1.0 / Math.pow(w2, 3.0) - Math.pow(t2, 3.0));
                double f2 = w2 / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, lt2 - 3.0 * cm1.m2._sum * f2 * d);
                cm1.m4 = (KahanObject)this._plus.execute((Data)cm1.m4, 6.0 * cm1.m2._sum * Math.pow(-f2 * d, 2.0) + lt3 - 4.0 * cm1.m3._sum * f2 * d);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case VARIANCE: {
                double w = cm1.w + w2;
                double d = in2 - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, w2 * d / w);
                double t1 = cm1.w * w2 / w * d;
                double lt1 = t1 * d;
                cm1.m2 = (KahanObject)this._plus.execute((Data)cm1.m2, lt1);
                cm1.w = w;
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported operation type: " + (Object)((Object)this._type));
            }
        }
        return cm1;
    }

    @Override
    public Data execute(Data in1, Data in2) {
        CM_COV_Object cm1 = (CM_COV_Object)in1;
        CM_COV_Object cm2 = (CM_COV_Object)in2;
        if (cm1.isCMAllZeros()) {
            cm1.w = cm2.w;
            cm1.mean.set(cm2.mean);
            cm1.m2.set(cm2.m2);
            cm1.m3.set(cm2.m3);
            cm1.m4.set(cm2.m4);
            return cm1;
        }
        if (cm2.isCMAllZeros()) {
            return cm1;
        }
        switch (this._type) {
            case COUNT: {
                cm1.w = Math.round(cm1.w + cm2.w);
                break;
            }
            case MEAN: {
                double w = cm1.w + cm2.w;
                double d = cm2.mean._sum - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, cm2.w * d / w);
                cm1.w = w;
                break;
            }
            case CM2: {
                double w = cm1.w + cm2.w;
                double d = cm2.mean._sum - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, cm2.w * d / w);
                double t1 = cm1.w * cm2.w / w * d;
                double lt1 = t1 * d;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute(this._buff2, cm2.m2._sum, cm2.m2._correction);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                cm1.m2.set(this._buff2);
                cm1.w = w;
                break;
            }
            case CM3: {
                double w = cm1.w + cm2.w;
                double d = cm2.mean._sum - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, cm2.w * d / w);
                double t1 = cm1.w * cm2.w / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 / Math.pow(cm2.w, 2.0) - Math.pow(t2, 2.0));
                double f1 = cm1.w / w;
                double f2 = cm2.w / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute(this._buff2, cm2.m2._sum, cm2.m2._correction);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute(this._buff3, cm2.m3._sum, cm2.m3._correction);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, 3.0 * (-f2 * cm1.m2._sum + f1 * cm2.m2._sum) * d + lt2);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case CM4: {
                double w = cm1.w + cm2.w;
                double d = cm2.mean._sum - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, cm2.w * d / w);
                double t1 = cm1.w * cm2.w / w * d;
                double t2 = -1.0 / cm1.w;
                double lt1 = t1 * d;
                double lt2 = Math.pow(t1, 3.0) * (1.0 / Math.pow(cm2.w, 2.0) - Math.pow(t2, 2.0));
                double lt3 = Math.pow(t1, 4.0) * (1.0 / Math.pow(cm2.w, 3.0) - Math.pow(t2, 3.0));
                double f1 = cm1.w / w;
                double f2 = cm2.w / w;
                this._buff2.set(cm1.m2);
                this._buff2 = (KahanObject)this._plus.execute(this._buff2, cm2.m2._sum, cm2.m2._correction);
                this._buff2 = (KahanObject)this._plus.execute((Data)this._buff2, lt1);
                this._buff3.set(cm1.m3);
                this._buff3 = (KahanObject)this._plus.execute(this._buff3, cm2.m3._sum, cm2.m3._correction);
                this._buff3 = (KahanObject)this._plus.execute((Data)this._buff3, 3.0 * (-f2 * cm1.m2._sum + f1 * cm2.m2._sum) * d + lt2);
                cm1.m4 = (KahanObject)this._plus.execute(cm1.m4, cm2.m4._sum, cm2.m4._correction);
                cm1.m4 = (KahanObject)this._plus.execute((Data)cm1.m4, 4.0 * (-f2 * cm1.m3._sum + f1 * cm2.m3._sum) * d + 6.0 * (Math.pow(-f2, 2.0) * cm1.m2._sum + Math.pow(f1, 2.0) * cm2.m2._sum) * Math.pow(d, 2.0) + lt3);
                cm1.m2.set(this._buff2);
                cm1.m3.set(this._buff3);
                cm1.w = w;
                break;
            }
            case VARIANCE: {
                double w = cm1.w + cm2.w;
                double d = cm2.mean._sum - cm1.mean._sum;
                cm1.mean = (KahanObject)this._plus.execute((Data)cm1.mean, cm2.w * d / w);
                double t1 = cm1.w * cm2.w / w * d;
                double lt1 = t1 * d;
                cm1.m2 = (KahanObject)this._plus.execute(cm1.m2, cm2.m2._sum, cm2.m2._correction);
                cm1.m2 = (KahanObject)this._plus.execute((Data)cm1.m2, lt1);
                cm1.w = w;
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported operation type: " + (Object)((Object)this._type));
            }
        }
        return cm1;
    }
}

