/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparable;

public class TensorIndexes
implements WritableComparable<TensorIndexes>,
Externalizable {
    private static final long serialVersionUID = -8596795142899904117L;
    private long[] _ix;

    public TensorIndexes() {
    }

    public TensorIndexes(long[] ix) {
        this.setIndexes(ix);
    }

    public TensorIndexes(TensorIndexes indexes) {
        this.setIndexes(indexes._ix);
    }

    public long getIndex(int dim) {
        return this._ix[dim];
    }

    public long[] getIndexes() {
        return this._ix;
    }

    public int getNumDims() {
        return this._ix.length;
    }

    public TensorIndexes setIndexes(long[] ix) {
        this._ix = (long[])ix.clone();
        return this;
    }

    public TensorIndexes setIndexes(TensorIndexes that) {
        this.setIndexes(that._ix);
        return this;
    }

    public int compareTo(TensorIndexes other) {
        for (int i = 0; i < this._ix.length; ++i) {
            if (this._ix[i] == other._ix[i]) continue;
            return this._ix[i] < other._ix[i] ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TensorIndexes)) {
            return false;
        }
        TensorIndexes tother = (TensorIndexes)other;
        return this.compareTo(tother) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this._ix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this._ix.length - 1; ++i) {
            sb.append(this._ix[i]).append(", ");
        }
        sb.append(this._ix[this._ix.length - 1]).append(")");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this._ix = new long[in.readInt()];
        for (int i = 0; i < this._ix.length; ++i) {
            this._ix[i] = in.readLong();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this._ix.length);
        for (long ix : this._ix) {
            out.writeLong(ix);
        }
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }
}

