/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.io.Serializable;
import org.tugraz.sysds.runtime.data.SparseRow;

public final class SparseRowScalar
extends SparseRow
implements Serializable {
    private static final long serialVersionUID = 722193514969067477L;
    private int index;
    private double value;

    public SparseRowScalar() {
        this.index = -1;
        this.value = 0.0;
    }

    public SparseRowScalar(int ix, double val) {
        this.index = ix;
        this.value = val;
    }

    @Override
    public int size() {
        return this.index < 0 ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.index < 0;
    }

    @Override
    public double[] values() {
        return new double[]{this.value};
    }

    @Override
    public int[] indexes() {
        return new int[]{this.index};
    }

    @Override
    public void reset(int estnns, int maxnns) {
        this.index = -1;
    }

    @Override
    public boolean set(int col, double v) {
        boolean ret;
        boolean bl = ret = this.index == col && v == 0.0 || this.index < 0 && v != 0.0;
        if (this.index >= 0 && this.index != col) {
            throw new RuntimeException("Invalid set to sparse row scalar.");
        }
        this.index = v != 0.0 ? col : -1;
        this.value = v;
        return ret;
    }

    @Override
    public boolean add(int col, double v) {
        return this.set(col, v + this.get(col));
    }

    @Override
    public void append(int col, double v) {
        if (v == 0.0) {
            return;
        }
        if (this.index >= 0) {
            throw new RuntimeException("Invalid append to sparse row scalar.");
        }
        this.index = col;
        this.value = v;
    }

    @Override
    public double get(int col) {
        return this.index == col ? this.value : 0.0;
    }

    @Override
    public void sort() {
    }

    @Override
    public void compact() {
        this.index = this.value != 0.0 ? this.index : -1;
    }
}

