/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class LibTensorBincell {
    public static boolean isValidDimensionsBinary(TensorBlock m1, TensorBlock m2) {
        if (m1.getNumDims() < m2.getNumDims()) {
            return false;
        }
        for (int i = 0; i < m2.getNumDims(); ++i) {
            if (m1.getDim(i) == m2.getDim(i) || m2.getDim(i) == 1) continue;
            return false;
        }
        return true;
    }

    public static void bincellOp(TensorBlock m1, TensorBlock m2, TensorBlock ret, BinaryOperator op) {
        int[] ix1 = new int[m1.getNumDims()];
        int[] ix2 = new int[m2.getNumDims()];
        block0: for (long i = 0L; i < ret.getLength(); ++i) {
            int j;
            double v1 = UtilFunctions.objectToDouble(m1.getValueType(), m1.get(ix1));
            double v2 = UtilFunctions.objectToDouble(m2.getValueType(), m2.get(ix2));
            ret.set(ix1, op.fn.execute(v1, v2));
            int n = j = ix1.length - 1;
            ix1[n] = ix1[n] + 1;
            if (j < ix2.length && m2.getDim(j) != 1) {
                int n2 = j;
                ix2[n2] = ix2[n2] + 1;
            }
            while (ix1[j] == m1.getDim(j)) {
                ix1[j] = 0;
                if (j < ix2.length) {
                    ix2[j] = 0;
                }
                if (--j < 0) continue block0;
                int n3 = j;
                ix1[n3] = ix1[n3] + 1;
                if (j >= ix2.length || m2.getDim(j) == 1) continue;
                int n4 = j;
                ix2[n4] = ix2[n4] + 1;
            }
        }
    }
}

