/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.util.Arrays;
import org.tugraz.sysds.common.Warnings;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.data.DenseBlockDRB;
import org.tugraz.sysds.runtime.util.DataConverter;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class DenseBlockString
extends DenseBlockDRB {
    private static final long serialVersionUID = 7071870563356352352L;
    protected String[] _data;

    public DenseBlockString(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new String[length];
    }

    public DenseBlockString(int[] dims, String[] data) {
        super(dims);
        this._data = data;
    }

    public String[] getData() {
        return this._data;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._data, start, length);
    }

    @Override
    public double[] values(int r) {
        return DataConverter.toDouble(this._data);
    }

    @Override
    public double[] valuesAt(int bix) {
        Warnings.warnFullFP64Conversion(this._data.length);
        return DataConverter.toDouble(this._data);
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public int pos(int r) {
        return r * this._odims[0];
    }

    @Override
    public int pos(int r, int c) {
        return r * this._odims[0] + c;
    }

    @Override
    public void incr(int r, int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incr(int r, int c, double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._data, fromIndex, toIndex, String.valueOf(v));
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._data[ix] = String.valueOf(v);
    }

    @Override
    public DenseBlock set(String s) {
        Arrays.fill(this._data, 0, this._data.length, s);
        return this;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._data[this.pos((int)r, (int)c)] = String.valueOf(v);
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        int[] ix = new int[this.numDims()];
        for (int r = 0; r < this._rlen; ++r) {
            ix[0] = r;
            for (int c = 0; c < this._odims[0]; ++c) {
                ix[ix.length - 1] = c;
                this._data[this.pos((int)r, (int)c)] = db.getString(ix);
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        System.arraycopy(DataConverter.toString(v), 0, this._data, this.pos(r), this._odims[0]);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._data[this.pos((int[])ix)] = String.valueOf(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._data[this.pos((int[])ix)] = String.valueOf(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        String s = this._data[this.pos(r, c)];
        return s == null || s.isEmpty() ? 0.0 : Double.parseDouble(s);
    }

    @Override
    public double get(int[] ix) {
        String s = this._data[this.pos(ix)];
        return s == null || s.isEmpty() ? 0.0 : Double.parseDouble(s);
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._data[this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public String getString(int[] ix) {
        return this._data[this.pos(ix)];
    }

    @Override
    public long getLong(int[] ix) {
        String s = this._data[this.pos(ix)];
        return s == null || s.isEmpty() ? 0L : Long.parseLong(s);
    }
}

