/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.util.Arrays;
import org.tugraz.sysds.common.Warnings;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.data.DenseBlockLDRB;
import org.tugraz.sysds.runtime.util.DataConverter;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class DenseBlockLString
extends DenseBlockLDRB {
    private static final long serialVersionUID = -6632424825959423264L;
    protected String[][] _blocks;

    public DenseBlockLString(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlocks(int numBlocks) {
        this._blocks = new String[numBlocks][];
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._blocks[bix] = new String[length];
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._blocks[bix][ix] = String.valueOf(v);
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isContiguous() {
        return this._blocks.length == 1;
    }

    @Override
    public int numBlocks() {
        return this._blocks.length;
    }

    @Override
    public long capacity() {
        return this._blocks != null ? (long)(this._blocks.length - 1) * (long)this._blocks[0].length + (long)this._blocks[this._blocks.length - 1].length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._blocks[bix], start, length);
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(this.index(r));
    }

    @Override
    public double[] valuesAt(int bix) {
        Warnings.warnFullFP64Conversion(this._blocks[bix].length);
        return DataConverter.toDouble(this._blocks[bix]);
    }

    @Override
    public void incr(int r, int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incr(int r, int c, double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._blocks[bix], fromIndex, toIndex, String.valueOf(v));
    }

    @Override
    public DenseBlock set(String s) {
        for (int i = 0; i < this.numBlocks() - 1; ++i) {
            Arrays.fill(this._blocks[i], 0, this.blockSize() * this._odims[0], s);
        }
        Arrays.fill(this._blocks[this.numBlocks() - 1], 0, this.blockSize(this.numBlocks() - 1) * this._odims[0], s);
        return this;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._blocks[this.index((int)r)][this.pos((int)r, (int)c)] = String.valueOf(v);
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        int[] ix = new int[this.numDims()];
        int roff = 0;
        for (int bi = 0; bi < this.numBlocks(); ++bi) {
            for (int r = 0; r < this.blockSize(); ++r) {
                ix[0] = r + roff;
                for (int c = 0; c < this._odims[0]; ++c) {
                    ix[ix.length - 1] = c;
                    this._blocks[bi][r * this._odims[0] + c] = db.getString(ix);
                }
            }
            roff += this.blockSize();
        }
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = String.valueOf(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = String.valueOf(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public double get(int r, int c) {
        return Double.parseDouble(this._blocks[this.index(r)][this.pos(r, c)]);
    }

    @Override
    public double get(int[] ix) {
        return Double.parseDouble(this._blocks[this.index(ix[0])][this.pos(ix)]);
    }

    @Override
    public String getString(int[] ix) {
        return this._blocks[this.index(ix[0])][this.pos(ix)];
    }

    @Override
    public long getLong(int[] ix) {
        return Long.parseLong(this._blocks[this.index(ix[0])][this.pos(ix)]);
    }
}

