/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.util.stream.IntStream;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class DenseBlockLDRB
extends DenseBlock {
    private static final long serialVersionUID = -7519435549328146356L;
    protected int _blen;

    protected DenseBlockLDRB(int[] dims) {
        super(dims);
    }

    protected abstract void allocateBlocks(int var1);

    @Override
    public int blockSize() {
        return this._blen;
    }

    @Override
    public int blockSize(int bix) {
        return Math.min(this._blen, this._rlen - bix * this._blen);
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        long dataLength = (long)rlen * (long)odims[0];
        int newBlockSize = Math.min(rlen, Integer.MAX_VALUE / odims[0]);
        int numBlocks = UtilFunctions.toInt(Math.ceil((double)rlen / (double)newBlockSize));
        if (this._blen == newBlockSize && dataLength <= this.capacity()) {
            IntStream.range(0, numBlocks).forEach(bi -> {
                int toIndex = (int)Math.min((long)newBlockSize, dataLength - (long)(bi * newBlockSize)) * this._odims[0];
                this.fillBlock(bi, 0, toIndex, v);
            });
        } else {
            int lastBlockSize = (newBlockSize == rlen ? newBlockSize : rlen % newBlockSize) * odims[0];
            this.allocateBlocks(numBlocks);
            IntStream.range(0, numBlocks).forEach(i -> {
                int length = i == numBlocks - 1 ? lastBlockSize : newBlockSize * this._odims[0];
                this.allocateBlock(i, length);
                if (v != 0.0) {
                    this.fillBlock(i, 0, length, v);
                }
            });
        }
        this._blen = newBlockSize;
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public int pos(int[] ix) {
        int pos = this.pos(ix[0]);
        pos += ix[ix.length - 1];
        for (int i = 1; i < ix.length - 1; ++i) {
            pos += ix[i] * this._odims[i];
        }
        return pos;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return this.index(rl) == this.index(ru);
    }

    @Override
    public int size(int bix) {
        return this.blockSize(bix) * this._odims[0];
    }

    @Override
    public int index(int r) {
        return r / this.blockSize();
    }

    @Override
    public int pos(int r) {
        return r % this.blockSize() * this._odims[0];
    }

    @Override
    public int pos(int r, int c) {
        return r % this.blockSize() * this._odims[0] + c;
    }

    @Override
    public long countNonZeros() {
        long nnz = 0L;
        for (int i = 0; i < this.numBlocks() - 1; ++i) {
            nnz += this.computeNnz(i, 0, this.blockSize() * this._odims[0]);
        }
        return nnz + this.computeNnz(this.numBlocks() - 1, 0, this.blockSize(this.numBlocks() - 1) * this._odims[0]);
    }

    @Override
    public int countNonZeros(int r) {
        return (int)this.computeNnz(this.index(r), this.pos(r), this._odims[0]);
    }

    @Override
    public long countNonZeros(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        boolean allColumns = cl == 0 && cu == this._odims[0];
        int rb = this.pos(rl);
        int re = this.blockSize() * this._odims[0];
        for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
            if (bi == this.index(ru - 1)) {
                re = this.pos(ru - 1) + this._odims[0];
            }
            if (allColumns) {
                nnz += this.computeNnz(bi, rb, re - rb);
            } else {
                for (int ri = rb; ri < re; ri += this._odims[0]) {
                    nnz += this.computeNnz(bi, ri + cl, cu - cl);
                }
            }
            rb = 0;
        }
        return nnz;
    }

    @Override
    public DenseBlock set(double v) {
        for (int i = 0; i < this.numBlocks() - 1; ++i) {
            this.fillBlock(i, 0, this.blockSize() * this._odims[0], v);
        }
        this.fillBlock(this.numBlocks() - 1, 0, this.blockSize(this.numBlocks() - 1) * this._odims[0], v);
        return this;
    }

    @Override
    public DenseBlock set(int rl, int ru, int cl, int cu, double v) {
        boolean allColumns = cl == 0 && cu == this._odims[0];
        int rb = this.pos(rl);
        int re = this.blockSize() * this._odims[0];
        for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
            if (bi == this.index(ru - 1)) {
                re = this.pos(ru - 1) + this._odims[0];
            }
            if (allColumns) {
                this.fillBlock(bi, rb, re, v);
            } else {
                for (int ri = rb; ri < re; ri += this._odims[0]) {
                    this.fillBlock(bi, ri + cl, ri + cu, v);
                }
            }
            rb = 0;
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        int bix = this.index(r);
        int offset = this.pos(r);
        IntStream.range(0, this._odims[0]).forEach(i -> this.setInternal(bix, offset + i, v[i]));
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        for (int ri = 0; ri < this._rlen; ri += this.blockSize()) {
            int bix = ri / this.blockSize();
            double[] other = db.valuesAt(bix);
            IntStream.range(0, this.blockSize(bix) * this._odims[0]).forEach(i -> this.setInternal(bix, i, other[i]));
        }
        return this;
    }
}

