/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.util.Arrays;
import org.tugraz.sysds.common.Warnings;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.data.DenseBlockDRB;
import org.tugraz.sysds.runtime.util.DataConverter;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class DenseBlockInt32
extends DenseBlockDRB {
    private static final long serialVersionUID = 3856034067703046872L;
    private int[] _data;

    public DenseBlockInt32(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new int[length];
    }

    public DenseBlockInt32(int[] dims, int[] data) {
        super(dims);
        this._data = data;
    }

    public int[] getData() {
        return this._data;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._data, start, length);
    }

    @Override
    public double[] values(int r) {
        double[] ret = this.getReuseRow(false);
        int ix = this.pos(r);
        int ncol = this._odims[0];
        for (int j = 0; j < ncol; ++j) {
            ret[j] = this._data[ix + j];
        }
        return ret;
    }

    @Override
    public double[] valuesAt(int bix) {
        Warnings.warnFullFP64Conversion(this._data.length);
        return DataConverter.toDouble(this._data);
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public void incr(int r, int c) {
        int n = this.pos(r, c);
        this._data[n] = this._data[n] + 1;
    }

    @Override
    public void incr(int r, int c, double delta) {
        int n = this.pos(r, c);
        this._data[n] = (int)((double)this._data[n] + delta);
    }

    @Override
    protected void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._data, fromIndex, toIndex, UtilFunctions.toInt(v));
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._data[ix] = UtilFunctions.toInt(v);
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._data[this.pos((int)r, (int)c)] = UtilFunctions.toInt(v);
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        double[] data = db.valuesAt(0);
        Arrays.parallelSetAll(this._data, i -> UtilFunctions.toInt(data[i]));
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        System.arraycopy(DataConverter.toInt(v), 0, this._data, this.pos(r), this._odims[0]);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._data[this.pos((int[])ix)] = UtilFunctions.toInt(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._data[this.pos((int[])ix)] = (int)v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._data[this.pos((int[])ix)] = Integer.parseInt(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._data[this.pos(r, c)];
    }

    @Override
    public double get(int[] ix) {
        return this._data[this.pos(ix)];
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._data[this.pos(ix)]);
    }

    @Override
    public long getLong(int[] ix) {
        return this._data[this.pos(ix)];
    }
}

