/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.util.BitSet;
import org.apache.commons.lang.NotImplementedException;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.data.DenseBlockBool;
import org.tugraz.sysds.runtime.data.DenseBlockDRB;
import org.tugraz.sysds.runtime.data.DenseBlockFP32;
import org.tugraz.sysds.runtime.data.DenseBlockFP64;
import org.tugraz.sysds.runtime.data.DenseBlockInt32;
import org.tugraz.sysds.runtime.data.DenseBlockInt64;
import org.tugraz.sysds.runtime.data.DenseBlockLBool;
import org.tugraz.sysds.runtime.data.DenseBlockLDRB;
import org.tugraz.sysds.runtime.data.DenseBlockLFP32;
import org.tugraz.sysds.runtime.data.DenseBlockLFP64;
import org.tugraz.sysds.runtime.data.DenseBlockLInt32;
import org.tugraz.sysds.runtime.data.DenseBlockLInt64;
import org.tugraz.sysds.runtime.data.DenseBlockLString;
import org.tugraz.sysds.runtime.data.DenseBlockString;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class DenseBlockFactory {
    public static DenseBlock createDenseBlock(int rlen, int clen) {
        return DenseBlockFactory.createDenseBlock(new int[]{rlen, clen});
    }

    public static DenseBlock createDenseBlock(int[] dims) {
        return DenseBlockFactory.createDenseBlock(Types.ValueType.FP64, dims);
    }

    public static DenseBlock createDenseBlock(Types.ValueType vt, int[] dims) {
        DenseBlock.Type type = UtilFunctions.prod(dims) < Integer.MAX_VALUE ? DenseBlock.Type.DRB : DenseBlock.Type.LDRB;
        return DenseBlockFactory.createDenseBlock(vt, type, dims);
    }

    public static DenseBlock createDenseBlock(BitSet data, int[] dims) {
        return new DenseBlockBool(dims, data);
    }

    public static DenseBlock createDenseBlock(String[] data, int[] dims) {
        return new DenseBlockString(dims, data);
    }

    public static DenseBlock createDenseBlock(double[] data, int[] dims) {
        return new DenseBlockFP64(dims, data);
    }

    public static DenseBlock createDenseBlock(float[] data, int[] dims) {
        return new DenseBlockFP32(dims, data);
    }

    public static DenseBlock createDenseBlock(long[] data, int[] dims) {
        return new DenseBlockInt64(dims, data);
    }

    public static DenseBlock createDenseBlock(int[] data, int[] dims) {
        return new DenseBlockInt32(dims, data);
    }

    public static DenseBlock createDenseBlock(double[] data, int rlen, int clen) {
        return DenseBlockFactory.createDenseBlock(data, new int[]{rlen, clen});
    }

    public static DenseBlock createDenseBlock(float[] data, int rlen, int clen) {
        return DenseBlockFactory.createDenseBlock(data, new int[]{rlen, clen});
    }

    public static DenseBlock createDenseBlock(Types.ValueType vt, DenseBlock.Type type, int[] dims) {
        switch (type) {
            case DRB: {
                switch (vt) {
                    case FP32: {
                        return new DenseBlockFP32(dims);
                    }
                    case FP64: {
                        return new DenseBlockFP64(dims);
                    }
                    case INT32: {
                        return new DenseBlockInt32(dims);
                    }
                    case INT64: {
                        return new DenseBlockInt64(dims);
                    }
                    case BOOLEAN: {
                        return new DenseBlockBool(dims);
                    }
                    case STRING: {
                        return new DenseBlockString(dims);
                    }
                }
                throw new DMLRuntimeException("Unsupported dense block value type: " + vt.name());
            }
            case LDRB: {
                switch (vt) {
                    case FP32: {
                        return new DenseBlockLFP32(dims);
                    }
                    case FP64: {
                        return new DenseBlockLFP64(dims);
                    }
                    case BOOLEAN: {
                        return new DenseBlockLBool(dims);
                    }
                    case INT32: {
                        return new DenseBlockLInt32(dims);
                    }
                    case INT64: {
                        return new DenseBlockLInt64(dims);
                    }
                    case STRING: {
                        return new DenseBlockLString(dims);
                    }
                }
                throw new NotImplementedException();
            }
        }
        throw new DMLRuntimeException("Unexpected dense block type: " + type.name());
    }

    public static boolean isDenseBlockType(DenseBlock sblock, DenseBlock.Type type) {
        return DenseBlockFactory.getDenseBlockType(sblock) == type;
    }

    public static DenseBlock.Type getDenseBlockType(DenseBlock dblock) {
        return dblock instanceof DenseBlockDRB ? DenseBlock.Type.DRB : (dblock instanceof DenseBlockLDRB ? DenseBlock.Type.LDRB : null);
    }
}

