/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.data;

import java.io.Serializable;
import java.util.Arrays;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.DenseBlockLString;
import org.tugraz.sysds.runtime.data.DenseBlockString;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class DenseBlock
implements Serializable {
    private static final long serialVersionUID = 7517220490270237832L;
    protected int _rlen;
    protected int[] _odims;
    private double[] _reuse;

    protected DenseBlock(int[] dims) {
        long odims = UtilFunctions.prod(dims, 1);
        if (odims > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Invalid dims: " + Arrays.toString(dims));
        }
        this._rlen = dims[0];
        this._odims = DenseBlock.createDimOffsets(dims);
    }

    protected abstract void allocateBlock(int var1, int var2);

    public final int getDim(int i) {
        return i == 0 ? this._rlen : (i == this._odims.length ? this._odims[i - 1] : this._odims[i - 1] / this._odims[i]);
    }

    public final int getCumODims(int i) {
        return this._odims[i];
    }

    public final void reset() {
        this.reset(this._rlen, this._odims, 0.0);
    }

    public final void reset(int[] dims) {
        this.reset(dims[0], DenseBlock.createDimOffsets(dims), 0.0);
    }

    public final void reset(int[] dims, double v) {
        this.reset(dims[0], DenseBlock.createDimOffsets(dims), v);
    }

    public final void reset(int rlen, int clen) {
        this.reset(rlen, new int[]{clen}, 0.0);
    }

    public final void reset(int rlen, int[] odims) {
        this.reset(rlen, odims, 0.0);
    }

    public final void reset(int rlen, int clen, double v) {
        this.reset(rlen, new int[]{clen}, v);
    }

    public abstract void reset(int var1, int[] var2, double var3);

    public final int numRows() {
        return this._rlen;
    }

    public final int numDims() {
        return 1 + this._odims.length;
    }

    public abstract int numBlocks();

    public abstract int blockSize();

    public abstract int blockSize(int var1);

    public abstract boolean isNumeric();

    public abstract boolean isContiguous();

    public abstract boolean isContiguous(int var1, int var2);

    public final long size() {
        return (long)this._rlen * (long)this._odims[0];
    }

    public abstract int size(int var1);

    public abstract long capacity();

    protected abstract long computeNnz(int var1, int var2, int var3);

    public abstract long countNonZeros();

    public abstract int countNonZeros(int var1);

    public abstract long countNonZeros(int var1, int var2, int var3, int var4);

    public abstract double[] values(int var1);

    public abstract double[] valuesAt(int var1);

    public abstract int index(int var1);

    public abstract int pos(int var1);

    public abstract int pos(int var1, int var2);

    public abstract int pos(int[] var1);

    public abstract void incr(int var1, int var2);

    public abstract void incr(int var1, int var2, double var3);

    protected abstract void fillBlock(int var1, int var2, int var3, double var4);

    protected abstract void setInternal(int var1, int var2, double var3);

    public abstract DenseBlock set(double var1);

    public DenseBlock set(String s) {
        this.set(Double.parseDouble(s));
        return this;
    }

    public abstract DenseBlock set(int var1, int var2, int var3, int var4, double var5);

    public abstract DenseBlock set(int var1, int var2, double var3);

    public abstract DenseBlock set(int var1, double[] var2);

    public abstract DenseBlock set(DenseBlock var1);

    public DenseBlock set(int rl, int ru, int cl, int cu, DenseBlock db) {
        boolean allColumns;
        boolean bl = allColumns = cl == 0 && cu == this._odims[0];
        if (db.isNumeric()) {
            int rowOther = 0;
            int colOther = 0;
            for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
                int i;
                if (allColumns) {
                    int offset = rl * this._odims[0] + cl;
                    for (i = 0; i < (ru - rl) * this._odims[0]; ++i) {
                        this.setInternal(bi, offset + i, db.get(rowOther, colOther));
                        if (++colOther != db.getCumODims(0)) continue;
                        ++rowOther;
                        colOther = 0;
                    }
                } else {
                    int len = cu - cl;
                    i = rl;
                    int ix1 = rl * this._odims[0] + cl;
                    while (i < ru) {
                        for (int ix = 0; ix < len; ++ix) {
                            this.setInternal(bi, ix1 + ix, db.get(rowOther, colOther));
                            if (++colOther != db.getCumODims(0)) continue;
                            ++rowOther;
                            colOther = 0;
                        }
                        ++i;
                        ix1 += this._odims[0];
                    }
                }
                rl = 0;
            }
        } else {
            int[] otherIx = new int[db.numDims()];
            for (int bi = this.index(rl); bi <= this.index(ru - 1); ++bi) {
                int i;
                String[] data = this instanceof DenseBlockString ? ((DenseBlockString)this)._data : ((DenseBlockLString)this)._blocks[bi];
                if (allColumns) {
                    int offset = rl * this._odims[0] + cl;
                    for (i = 0; i < (ru - rl) * this._odims[0]; ++i) {
                        data[offset + i] = db.getString(otherIx);
                        this.getNextIndexes(otherIx);
                    }
                } else {
                    int len = cu - cl;
                    i = rl;
                    int ix1 = rl * this._odims[0] + cl;
                    while (i < ru) {
                        for (int ix = 0; ix < len; ++ix) {
                            data[ix1 + ix] = db.getString(otherIx);
                            this.getNextIndexes(otherIx);
                        }
                        otherIx[0] = i - rl + 1;
                        otherIx[1] = 0;
                        Arrays.fill(otherIx, 2, otherIx.length, 0);
                        ++i;
                        ix1 += this._odims[0];
                    }
                }
                rl = 0;
            }
        }
        return this;
    }

    public void getNextIndexes(int[] ix) {
        int i;
        int n = i = ix.length - 1;
        ix[n] = ix[n] + 1;
        if (ix[i] == this.getDim(i)) {
            while (ix[i] == this.getDim(i) && i - 1 >= 0) {
                ix[i] = 0;
                int n2 = --i;
                ix[n2] = ix[n2] + 1;
            }
        }
    }

    public DenseBlock set(KahanObject kbuff) {
        this.set(0, 0, kbuff._sum);
        this.set(0, 1, kbuff._correction);
        return this;
    }

    public abstract DenseBlock set(int[] var1, double var2);

    public abstract DenseBlock set(int[] var1, long var2);

    public abstract DenseBlock set(int[] var1, String var2);

    public DenseBlock set(int r, KahanObject kbuff) {
        this.set(r, 0, kbuff._sum);
        this.set(r, 1, kbuff._correction);
        return this;
    }

    public abstract double get(int var1, int var2);

    public abstract double get(int[] var1);

    public abstract String getString(int[] var1);

    public abstract long getLong(int[] var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._rlen; ++i) {
            double[] data = this.values(i);
            int ix = this.pos(i);
            for (int j = 0; j < this._odims[0]; ++j) {
                sb.append(data[ix + j]);
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected double[] getReuseRow(boolean reset) {
        if (this._reuse != null && reset) {
            Arrays.fill(this._reuse, 0.0);
        }
        if (this._reuse == null) {
            this._reuse = new double[this._odims[0]];
        }
        return this._reuse;
    }

    private static int[] createDimOffsets(int[] dims) {
        int[] ret = new int[dims.length - 1];
        int prod = 1;
        for (int i = dims.length - 1; i >= 1; --i) {
            ret[i - 1] = prod *= dims[i];
        }
        return ret;
    }

    public static enum Type {
        DRB,
        LDRB;

    }
}

