/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.Cell;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.FastStringTokenizer;

public class StagingFileUtils {
    public static final int CELL_BUFFER_SIZE = 100000;

    public static void writeCellListToLocal(String fname, LinkedList<Cell> buffer) throws IOException {
        FileOutputStream fos = new FileOutputStream(fname, true);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fos));){
            StringBuilder sb = new StringBuilder();
            for (Cell c : buffer) {
                sb.append(c.getRow());
                sb.append(' ');
                sb.append(c.getCol());
                sb.append(' ');
                sb.append(c.getValue());
                sb.append('\n');
                out.write(sb.toString());
                sb.setLength(0);
            }
        }
    }

    public static void writeKeyMappingToLocal(String fname, long[][] keys) throws IOException {
        FileOutputStream fos = new FileOutputStream(fname, true);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fos));){
            StringBuilder sb = new StringBuilder();
            for (long[] key : keys) {
                sb.append(key[0]);
                sb.append(' ');
                sb.append(key[1]);
                sb.append('\n');
                out.write(sb.toString());
                sb.setLength(0);
            }
        }
    }

    public static BufferedReader openKeyMap(String name) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(name);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        return in;
    }

    public static void nextKeyMap(BufferedReader in, HashMap<Integer, HashMap<Long, Long>> map, int bi, int blen) throws NumberFormatException, IOException {
        String value = null;
        FastStringTokenizer st = new FastStringTokenizer(' ');
        while ((value = in.readLine()) != null) {
            st.reset(value);
            long row1 = st.nextLong();
            long row2 = st.nextLong();
            int id = (int)row1 / blen;
            if (!map.containsKey(id)) {
                map.put(id, new HashMap());
            }
            map.get(id).put(row1, row2);
            if (id <= bi) continue;
            break;
        }
    }

    public static int nextSizedKeyMap(BufferedReader in, HashMap<Integer, HashMap<Long, Long>> map, int blen, int size) throws NumberFormatException, IOException {
        map.clear();
        String value = null;
        int len = 0;
        FastStringTokenizer st = new FastStringTokenizer(' ');
        while ((value = in.readLine()) != null) {
            st.reset(value);
            long row1 = st.nextLong();
            long row2 = st.nextLong();
            int id = (int)row1 / blen;
            if (!map.containsKey(id)) {
                map.put(id, new HashMap());
            }
            map.get(id).put(row1, row2);
            if (++len < size) continue;
            break;
        }
        return len;
    }

    public static LinkedList<Cell> readCellListFromLocal(String fname) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        LinkedList<Cell> buffer = new LinkedList<Cell>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
            String value = null;
            FastStringTokenizer st = new FastStringTokenizer(' ');
            while ((value = in.readLine()) != null) {
                st.reset(value);
                long row = st.nextLong();
                long col = st.nextLong();
                double lvalue = st.nextDouble();
                Cell c = new Cell(row, col, lvalue);
                buffer.addLast(c);
            }
        }
        return buffer;
    }

    public static MatrixBlock readCellList2BlockFromLocal(String fname, int blen) throws IOException, DMLRuntimeException {
        return StagingFileUtils.readCellList2BlockFromLocal(fname, blen, false);
    }

    public static MatrixBlock readCellList2BlockFromLocal(String fname, int blen, boolean sparse) throws IOException, DMLRuntimeException {
        MatrixBlock tmp = new MatrixBlock(blen, blen, sparse);
        if (!sparse) {
            tmp.allocateDenseBlockUnsafe(blen, blen);
        }
        FileInputStream fis = new FileInputStream(fname);
        FastStringTokenizer st = new FastStringTokenizer(' ');
        try (BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
            String value = null;
            if (sparse) {
                while ((value = in.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    int col = st.nextInt();
                    double lvalue = st.nextDouble();
                    tmp.quickSetValue(row, col, lvalue);
                }
            } else {
                DenseBlock a = tmp.getDenseBlock();
                while ((value = in.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    int col = st.nextInt();
                    double lvalue = st.nextDouble();
                    a.set(row, col, lvalue);
                }
                tmp.recomputeNonZeros();
            }
        }
        tmp.examSparsity();
        return tmp;
    }
}

