/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor.util;

import java.util.concurrent.atomic.AtomicLong;

public class IDSequence {
    private final AtomicLong _current = new AtomicLong(-1L);
    private final boolean _cyclic;
    private final long _cycleLen;

    public IDSequence() {
        this(false, -1L);
    }

    public IDSequence(boolean cyclic) {
        this(cyclic, Long.MAX_VALUE);
    }

    public IDSequence(boolean cyclic, long cycleLen) {
        this._cyclic = cyclic;
        this._cycleLen = cycleLen;
    }

    public long getNextID() {
        long val = this._current.incrementAndGet();
        if (val == this._cycleLen) {
            if (!this._cyclic) {
                throw new RuntimeException("WARNING: IDSequence will produced numeric overflow.");
            }
            this.reset();
        }
        return val;
    }

    public long getCurrentID() {
        return this._current.get();
    }

    public void reset() {
        this.reset(0L);
    }

    public void reset(long value) {
        this._current.set(value);
    }
}

