/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor.stat;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class InfrastructureAnalyzer {
    public static final long DEFAULT_JVM_SIZE = 0x20000000L;
    public static final String MR_FRAMEWORK_NAME = "mapreduce.framework.name";
    public static final String MR_JOBTRACKER_ADDRESS = "mapreduce.jobtracker.address";
    private static int _localPar = -1;
    private static long _localJVMMaxMem = -1L;
    private static long _fLocalJVMMaxMem = -1L;
    private static int _remotePar = -1;
    private static int _remoteParMap = -1;
    private static int _remoteParReduce = -1;
    private static boolean _localJT = false;
    private static long _blocksize = -1L;

    public static int getLocalParallelism() {
        return _localPar;
    }

    public static int getRemoteParallelNodes() {
        if (_remotePar == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remotePar;
    }

    public static int getRemoteParallelMapTasks() {
        if (_remotePar == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remoteParMap;
    }

    public static void setRemoteParallelMapTasks(int pmap) {
        _remoteParMap = pmap;
    }

    public static int getRemoteParallelReduceTasks() {
        if (_remotePar == -1) {
            InfrastructureAnalyzer.analyzeHadoopCluster();
        }
        return _remoteParReduce;
    }

    public static void setRemoteParallelReduceTasks(int preduce) {
        _remoteParReduce = preduce;
    }

    public static long getLocalMaxMemory() {
        return _localJVMMaxMem;
    }

    public static void setLocalMaxMemory(long localMem) {
        _localJVMMaxMem = localMem;
    }

    public static double getLocalMaxMemoryFraction() {
        return (double)_localJVMMaxMem / (double)_fLocalJVMMaxMem;
    }

    public static boolean isLocalMode() {
        if (_remotePar == -1) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _localJT;
    }

    public static boolean isLocalMode(JobConf job) {
        String jobTracker = job.get(MR_JOBTRACKER_ADDRESS, "local");
        String framework = job.get(MR_FRAMEWORK_NAME, "local");
        boolean isYarnEnabled = framework != null && framework.equals("yarn");
        return "local".equals(jobTracker) & !isYarnEnabled;
    }

    public static int getCkMaxCP() {
        return InfrastructureAnalyzer.getLocalParallelism();
    }

    public static int getCkMaxMR() {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(true);
        }
        return InfrastructureAnalyzer.getRemoteParallelMapTasks();
    }

    public static long getCmMax() {
        return InfrastructureAnalyzer.getLocalMaxMemory();
    }

    public static long getHDFSBlockSize() {
        if (_blocksize == -1L) {
            InfrastructureAnalyzer.analyzeHadoopConfiguration();
        }
        return _blocksize;
    }

    public static long extractMaxMemoryOpt(String javaOpts) {
        long ret = -1L;
        try {
            StringTokenizer st = new StringTokenizer(javaOpts, " ");
            while (st.hasMoreTokens()) {
                String arg = st.nextToken();
                if (!arg.startsWith("-Xmx")) continue;
                arg = arg.substring(4);
                ret = UtilFunctions.parseMemorySize(arg);
            }
            if (ret < 0L) {
                ret = 0x20000000L;
            }
        }
        catch (Exception ex) {
            ret = 0x20000000L;
        }
        return ret;
    }

    public static void setMaxMemoryOpt(JobConf job, String key, long bytes) {
        String javaOptsOld = job.get(key);
        String javaOptsNew = null;
        String[] tokens = javaOptsOld.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String arg : tokens) {
            if (arg.startsWith("-Xmx")) {
                sb.append("-Xmx");
                sb.append(bytes / 0x100000L);
                sb.append("M");
            } else {
                sb.append(arg);
            }
            sb.append(" ");
        }
        javaOptsNew = sb.toString().trim();
        job.set(key, javaOptsNew);
    }

    public static double getClusterUtilization(boolean mapOnly) throws IOException {
        JobConf job = ConfigurationManager.getCachedJobConf();
        JobClient client = new JobClient(job);
        ClusterStatus stat = client.getClusterStatus();
        double ret = 0.0;
        if (stat != null) {
            if (mapOnly) {
                int capacity = stat.getMaxMapTasks();
                int current = stat.getMapTasks();
                ret = (double)current / (double)capacity;
            } else {
                int capacity = stat.getMaxMapTasks() + stat.getMaxReduceTasks();
                int current = stat.getMapTasks() + stat.getReduceTasks();
                ret = (double)current / (double)capacity;
            }
        }
        return ret;
    }

    private static void analyzeLocalMachine() {
        _localPar = Runtime.getRuntime().availableProcessors();
        _fLocalJVMMaxMem = _localJVMMaxMem = Runtime.getRuntime().maxMemory();
    }

    private static void analyzeHadoopCluster() {
        try {
            JobConf job = ConfigurationManager.getCachedJobConf();
            JobClient client = new JobClient(job);
            ClusterStatus stat = client.getClusterStatus();
            if (stat != null) {
                _remotePar = stat.getTaskTrackers();
                _remoteParMap = stat.getMaxMapTasks();
                _remoteParReduce = stat.getMaxReduceTasks();
                InfrastructureAnalyzer.analyzeHadoopConfiguration();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to analyze infrastructure.", e);
        }
    }

    private static void analyzeHadoopConfiguration() {
        JobConf job = ConfigurationManager.getCachedJobConf();
        String blocksize = job.get("dfs.blocksize", "134217728");
        _blocksize = Long.parseLong(blocksize);
        _localJT = InfrastructureAnalyzer.analyzeLocalMode(job);
    }

    private static boolean analyzeLocalMode(JobConf job) {
        String jobTracker = job.get(MR_JOBTRACKER_ADDRESS, "local");
        return "local".equals(jobTracker);
    }

    static {
        InfrastructureAnalyzer.analyzeLocalMachine();
    }
}

