/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor.opt;

import java.util.ArrayList;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.conf.DMLConfig;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.IndexingOp;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.codegen.SpoofCompiler;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DMLTranslator;
import org.tugraz.sysds.parser.ForStatement;
import org.tugraz.sysds.parser.ForStatementBlock;
import org.tugraz.sysds.parser.IfStatement;
import org.tugraz.sysds.parser.IfStatementBlock;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.WhileStatement;
import org.tugraz.sysds.parser.WhileStatementBlock;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.IfProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.WhileProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;

public class ProgramRecompiler {
    public static ArrayList<ProgramBlock> generatePartitialRuntimeProgram(Program rtprog, ArrayList<StatementBlock> sbs) {
        ArrayList<ProgramBlock> ret = new ArrayList<ProgramBlock>();
        DMLConfig config = ConfigurationManager.getDMLConfig();
        DMLTranslator dmlt = new DMLTranslator(sbs.get(0).getDMLProg());
        for (StatementBlock sb : sbs) {
            dmlt.constructLops(sb);
        }
        for (StatementBlock sb : sbs) {
            ret.add(dmlt.createRuntimeProgramBlock(rtprog, sb, config));
        }
        if (ConfigurationManager.isCodegenEnabled() && SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.RUNTIME) {
            for (ProgramBlock pb : ret) {
                dmlt.codgenHopsDAG(pb);
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rFindAndRecompileIndexingHOP(StatementBlock sb, ProgramBlock pb, String var, ExecutionContext ec, boolean force) {
        if (pb instanceof IfProgramBlock && sb instanceof IfStatementBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement is = (IfStatement)sb.getStatement(0);
            if (isb.getPredicateHops() != null) {
                ipb.setPredicate(ProgramRecompiler.rFindAndRecompileIndexingHOP(isb.getPredicateHops(), ipb.getPredicate(), var, ec, force));
            }
            int len = is.getIfBody().size();
            for (int i = 0; i < ipb.getChildBlocksIfBody().size() && i < len; ++i) {
                ProgramBlock lpb = ipb.getChildBlocksIfBody().get(i);
                StatementBlock lsb = is.getIfBody().get(i);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(lsb, lpb, var, ec, force);
            }
            if (ipb.getChildBlocksElseBody() == null) return;
            int len2 = is.getElseBody().size();
            for (int i = 0; i < ipb.getChildBlocksElseBody().size() && i < len2; ++i) {
                ProgramBlock lpb = ipb.getChildBlocksElseBody().get(i);
                StatementBlock lsb = is.getElseBody().get(i);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(lsb, lpb, var, ec, force);
            }
            return;
        }
        if (pb instanceof WhileProgramBlock && sb instanceof WhileStatementBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement ws = (WhileStatement)sb.getStatement(0);
            if (wsb.getPredicateHops() != null) {
                wpb.setPredicate(ProgramRecompiler.rFindAndRecompileIndexingHOP(wsb.getPredicateHops(), wpb.getPredicate(), var, ec, force));
            }
            int len = ws.getBody().size();
            for (int i = 0; i < wpb.getChildBlocks().size() && i < len; ++i) {
                ProgramBlock lpb = wpb.getChildBlocks().get(i);
                StatementBlock lsb = ws.getBody().get(i);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(lsb, lpb, var, ec, force);
            }
            return;
        }
        if (pb instanceof ForProgramBlock && sb instanceof ForStatementBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            if (fsb.getFromHops() != null) {
                fpb.setFromInstructions(ProgramRecompiler.rFindAndRecompileIndexingHOP(fsb.getFromHops(), fpb.getFromInstructions(), var, ec, force));
            }
            if (fsb.getToHops() != null) {
                fpb.setToInstructions(ProgramRecompiler.rFindAndRecompileIndexingHOP(fsb.getToHops(), fpb.getToInstructions(), var, ec, force));
            }
            if (fsb.getIncrementHops() != null) {
                fpb.setIncrementInstructions(ProgramRecompiler.rFindAndRecompileIndexingHOP(fsb.getIncrementHops(), fpb.getIncrementInstructions(), var, ec, force));
            }
            int len = fs.getBody().size();
            for (int i = 0; i < fpb.getChildBlocks().size() && i < len; ++i) {
                ProgramBlock lpb = fpb.getChildBlocks().get(i);
                StatementBlock lsb = fs.getBody().get(i);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(lsb, lpb, var, ec, force);
            }
            return;
        }
        if (!(pb instanceof BasicProgramBlock)) return;
        BasicProgramBlock bpb = (BasicProgramBlock)pb;
        try {
            boolean ret = false;
            Hop.resetVisitStatus(sb.getHops());
            if (force) {
                for (Hop h : sb.getHops()) {
                    ret |= ProgramRecompiler.rFindAndSetCPIndexingHOP(h, var);
                }
            } else {
                for (Hop h : sb.getHops()) {
                    ret |= ProgramRecompiler.rFindAndReleaseIndexingHOP(h, var);
                }
            }
            if (!ret) return;
            ArrayList<Instruction> newInst = Recompiler.recompileHopsDag(sb, sb.getHops(), ec.getVariables(), null, true, false, 0L);
            bpb.setInstructions(newInst);
            return;
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static LocalVariableMap getReusableScalarVariables(DMLProgram prog, StatementBlock parforSB, LocalVariableMap vars) {
        LocalVariableMap constVars = new LocalVariableMap();
        for (String varname : vars.keySet()) {
            Data dat = vars.get(varname);
            if (!(dat instanceof ScalarObject) || !ProgramRecompiler.isApplicableForReuseVariable(prog, parforSB, varname)) continue;
            constVars.put(varname, dat);
        }
        return constVars;
    }

    public static void replaceConstantScalarVariables(StatementBlock sb, LocalVariableMap vars) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(sb instanceof IfStatementBlock)) break block5;
                        IfStatementBlock isb = (IfStatementBlock)sb;
                        IfStatement is = (IfStatement)sb.getStatement(0);
                        ProgramRecompiler.replacePredicateLiterals(isb.getPredicateHops(), vars);
                        for (StatementBlock lsb : is.getIfBody()) {
                            ProgramRecompiler.replaceConstantScalarVariables(lsb, vars);
                        }
                        for (StatementBlock lsb : is.getElseBody()) {
                            ProgramRecompiler.replaceConstantScalarVariables(lsb, vars);
                        }
                        break block6;
                    }
                    if (!(sb instanceof WhileStatementBlock)) break block7;
                    WhileStatementBlock wsb = (WhileStatementBlock)sb;
                    WhileStatement ws = (WhileStatement)sb.getStatement(0);
                    ProgramRecompiler.replacePredicateLiterals(wsb.getPredicateHops(), vars);
                    for (StatementBlock lsb : ws.getBody()) {
                        ProgramRecompiler.replaceConstantScalarVariables(lsb, vars);
                    }
                    break block6;
                }
                if (!(sb instanceof ForStatementBlock)) break block8;
                ForStatementBlock fsb = (ForStatementBlock)sb;
                ForStatement fs = (ForStatement)fsb.getStatement(0);
                ProgramRecompiler.replacePredicateLiterals(fsb.getFromHops(), vars);
                ProgramRecompiler.replacePredicateLiterals(fsb.getToHops(), vars);
                ProgramRecompiler.replacePredicateLiterals(fsb.getIncrementHops(), vars);
                for (StatementBlock lsb : fs.getBody()) {
                    ProgramRecompiler.replaceConstantScalarVariables(lsb, vars);
                }
                break block6;
            }
            ArrayList<Hop> hops = sb.getHops();
            if (hops == null) break block6;
            Hop.resetVisitStatus(hops);
            for (Hop hopRoot : hops) {
                Recompiler.rReplaceLiterals(hopRoot, vars, true);
            }
        }
    }

    private static void replacePredicateLiterals(Hop pred, LocalVariableMap vars) {
        if (pred != null) {
            pred.resetVisitStatus();
            Recompiler.rReplaceLiterals(pred, vars, true);
        }
    }

    public static boolean isApplicableForReuseVariable(DMLProgram prog, StatementBlock parforSB, String var) {
        boolean ret = false;
        for (StatementBlock sb : prog.getStatementBlocks()) {
            ret |= ProgramRecompiler.isApplicableForReuseVariable(sb, parforSB, var);
        }
        return ret;
    }

    private static boolean isApplicableForReuseVariable(StatementBlock sb, StatementBlock parforSB, String var) {
        boolean ret;
        block7: {
            block8: {
                block6: {
                    ret = false;
                    if (!(sb instanceof IfStatementBlock)) break block6;
                    IfStatement is = (IfStatement)sb.getStatement(0);
                    for (StatementBlock lsb : is.getIfBody()) {
                        ret |= ProgramRecompiler.isApplicableForReuseVariable(lsb, parforSB, var);
                    }
                    for (StatementBlock lsb : is.getElseBody()) {
                        ret |= ProgramRecompiler.isApplicableForReuseVariable(lsb, parforSB, var);
                    }
                    break block7;
                }
                if (!(sb instanceof WhileStatementBlock)) break block8;
                WhileStatement ws = (WhileStatement)sb.getStatement(0);
                for (StatementBlock lsb : ws.getBody()) {
                    ret |= ProgramRecompiler.isApplicableForReuseVariable(lsb, parforSB, var);
                }
                break block7;
            }
            if (!(sb instanceof ForStatementBlock)) break block7;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            if (fsb == parforSB) {
                ret = true;
            } else {
                for (StatementBlock lsb : fs.getBody()) {
                    ret |= ProgramRecompiler.isApplicableForReuseVariable(lsb, parforSB, var);
                }
            }
        }
        return ret && !sb.variablesUpdated().containsVariable(var);
    }

    public static boolean containsAtLeastOneFunction(ProgramBlock pb) {
        block6: {
            BasicProgramBlock bpb;
            block8: {
                block7: {
                    block5: {
                        if (!(pb instanceof IfProgramBlock)) break block5;
                        IfProgramBlock ipb = (IfProgramBlock)pb;
                        for (ProgramBlock lpb : ipb.getChildBlocksIfBody()) {
                            if (!ProgramRecompiler.containsAtLeastOneFunction(lpb)) continue;
                            return true;
                        }
                        for (ProgramBlock lpb : ipb.getChildBlocksElseBody()) {
                            if (!ProgramRecompiler.containsAtLeastOneFunction(lpb)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!(pb instanceof WhileProgramBlock)) break block7;
                    WhileProgramBlock wpb = (WhileProgramBlock)pb;
                    for (ProgramBlock lpb : wpb.getChildBlocks()) {
                        if (!ProgramRecompiler.containsAtLeastOneFunction(lpb)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(pb instanceof ForProgramBlock)) break block8;
                ForProgramBlock fpb = (ForProgramBlock)pb;
                for (ProgramBlock lpb : fpb.getChildBlocks()) {
                    if (!ProgramRecompiler.containsAtLeastOneFunction(lpb)) continue;
                    return true;
                }
                break block6;
            }
            if (!(pb instanceof BasicProgramBlock) || (bpb = (BasicProgramBlock)pb).getInstructions() == null) break block6;
            for (Instruction inst : bpb.getInstructions()) {
                if (!(inst instanceof FunctionCallCPInstruction)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList<Instruction> rFindAndRecompileIndexingHOP(Hop hop, ArrayList<Instruction> in, String var, ExecutionContext ec, boolean force) {
        ArrayList<Instruction> tmp = in;
        try {
            boolean ret = false;
            hop.resetVisitStatus();
            ret = force ? ProgramRecompiler.rFindAndSetCPIndexingHOP(hop, var) : ProgramRecompiler.rFindAndReleaseIndexingHOP(hop, var);
            if (ret) {
                tmp = Recompiler.recompileHopsDag(hop, ec.getVariables(), null, true, false, 0L);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return tmp;
    }

    private static boolean rFindAndSetCPIndexingHOP(Hop hop, String var) {
        String inMatrix;
        boolean ret = false;
        if (hop.isVisited()) {
            return ret;
        }
        ArrayList<Hop> in = hop.getInput();
        if (hop instanceof IndexingOp && (inMatrix = hop.getInput().get(0).getName()).equals(var)) {
            if (hop.getMemEstimate() < OptimizerUtils.getLocalMemBudget()) {
                hop.setForcedExecType(LopProperties.ExecType.CP);
            } else {
                hop.setForcedExecType(LopProperties.ExecType.CP_FILE);
            }
            ret = true;
        }
        if (in != null) {
            for (Hop hin : in) {
                ret |= ProgramRecompiler.rFindAndSetCPIndexingHOP(hin, var);
            }
        }
        hop.setVisited();
        return ret;
    }

    private static boolean rFindAndReleaseIndexingHOP(Hop hop, String var) {
        String inMatrix;
        boolean ret = false;
        if (hop.isVisited()) {
            return ret;
        }
        ArrayList<Hop> in = hop.getInput();
        if (hop instanceof IndexingOp && (inMatrix = hop.getInput().get(0).getName()).equals(var)) {
            hop.setForcedExecType(null);
            hop.clearMemEstimate();
            ret = true;
        }
        if (in != null) {
            for (Hop hin : in) {
                ret |= ProgramRecompiler.rFindAndReleaseIndexingHOP(hin, var);
            }
        }
        hop.setVisited();
        return ret;
    }

    protected static ArrayList<Instruction> createNestedParallelismToInstructionSet(String iterVar, String offset) {
        StringBuilder sb = new StringBuilder("CP\u00b0+\u00b0");
        sb.append(iterVar);
        sb.append("\u00b7SCALAR\u00b7INT\u00b0");
        sb.append(offset);
        sb.append("\u00b7SCALAR\u00b7INT\u00b0");
        sb.append(iterVar);
        sb.append("\u00b7SCALAR\u00b7INT");
        String str = sb.toString();
        ArrayList<Instruction> tmp = new ArrayList<Instruction>();
        BinaryCPInstruction inst = BinaryCPInstruction.parseInstruction(str);
        tmp.add(inst);
        return tmp;
    }
}

