/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor.opt;

import org.tugraz.sysds.hops.cost.CostEstimationWrapper;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.CostEstimator;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.CostEstimatorHops;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;

public class CostEstimatorRuntime
extends CostEstimator {
    private final CostEstimatorHops _costMem;
    private final OptTreePlanMappingAbstract _map;
    private final ExecutionContext _ec;

    public CostEstimatorRuntime(OptTreePlanMappingAbstract map, LocalVariableMap vars) {
        this._costMem = new CostEstimatorHops(map);
        this._map = map;
        this._ec = ExecutionContextFactory.createContext();
        this._ec.setVariables(vars);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) {
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node);
        }
        return this.getLeafNodeEstimate(measure, node, node.isCPOnly() ? LopProperties.ExecType.CP : LopProperties.ExecType.SPARK);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, LopProperties.ExecType et) {
        boolean isCP;
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node, et);
        }
        double ret = 5.0;
        boolean bl = isCP = et == LopProperties.ExecType.CP || et == null;
        if (!node.isLeaf() && isCP) {
            ProgramBlock pb = (ProgramBlock)this._map.getMappedProg(node.getID())[1];
            ret = CostEstimationWrapper.getTimeEstimate(pb, this._ec, true);
        }
        return ret;
    }
}

