/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor;

import java.util.List;
import org.tugraz.sysds.runtime.controlprogram.parfor.LocalTaskQueue;
import org.tugraz.sysds.runtime.controlprogram.parfor.Task;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;

public abstract class TaskPartitioner {
    protected long _taskSize = -1L;
    protected String _iterVarName = null;
    protected IntObject _fromVal = null;
    protected IntObject _toVal = null;
    protected IntObject _incrVal = null;
    protected long _numIter = -1L;

    protected TaskPartitioner(long taskSize, String iterVarName, IntObject fromVal, IntObject toVal, IntObject incrVal) {
        this._taskSize = taskSize;
        this._iterVarName = iterVarName;
        this._fromVal = fromVal;
        this._toVal = toVal;
        this._incrVal = incrVal;
        this.normalizePredicate();
        this._numIter = (long)Math.ceil((double)(this._toVal.getLongValue() - this._fromVal.getLongValue() + 1L) / (double)this._incrVal.getLongValue());
    }

    public abstract List<Task> createTasks();

    public abstract long createTasks(LocalTaskQueue<Task> var1);

    public long getNumIterations() {
        return this._numIter;
    }

    private void normalizePredicate() {
        if (this._incrVal.getLongValue() >= 0L) {
            return;
        }
        long lfrom = this._fromVal.getLongValue();
        long lto = this._toVal.getLongValue();
        long lincr = this._incrVal.getLongValue();
        this._fromVal = new IntObject(lfrom - (lfrom - lto) / lincr * lincr);
        this._toVal = new IntObject(lfrom);
        this._incrVal = new IntObject(-1L * lincr);
    }
}

