/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;

public class Task
implements Serializable {
    private static final long serialVersionUID = 2815832451487164284L;
    public static final int MAX_VARNAME_SIZE = 256;
    public static final int MAX_TASK_SIZE = 0x7FFFFFFE;
    private String _iterVar;
    private TaskType _type;
    private LinkedList<IntObject> _iterations;

    public Task() {
    }

    public Task(String iterVar, TaskType type) {
        if (iterVar.length() > 256) {
            throw new RuntimeException("Cannot create task, MAX_VARNAME_SIZE exceeded.");
        }
        this._iterVar = iterVar;
        this._type = type;
        this._iterations = new LinkedList();
    }

    public void addIteration(IntObject indexVal) {
        if (this.size() >= 0x7FFFFFFE) {
            throw new RuntimeException("Cannot add iteration, MAX_TASK_SIZE reached.");
        }
        this._iterations.addLast(indexVal);
    }

    public List<IntObject> getIterations() {
        return this._iterations;
    }

    public TaskType getType() {
        return this._type;
    }

    public String getVarName() {
        return this._iterVar;
    }

    public int size() {
        return this._iterations.size();
    }

    public String toString() {
        return this.toFormatedString();
    }

    public String toFormatedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("task (type=");
        sb.append((Object)this._type);
        sb.append(", iterations={");
        int count = 0;
        for (IntObject dat : this._iterations) {
            if (count != 0) {
                sb.append(";");
            }
            sb.append("[");
            sb.append(this._iterVar);
            sb.append("=");
            sb.append(dat.getLongValue());
            sb.append("]");
            ++count;
        }
        sb.append("})");
        return sb.toString();
    }

    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._type);
        if (this.size() > 0) {
            sb.append(".");
            sb.append(this._iterVar);
            sb.append(".{");
            int count = 0;
            for (IntObject dat : this._iterations) {
                if (count != 0) {
                    sb.append(",");
                }
                sb.append(dat.getLongValue());
                ++count;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public String toCompactString(int maxDigits) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._type);
        if (this.size() > 0) {
            sb.append(".");
            sb.append(this._iterVar);
            sb.append(".{");
            int count = 0;
            for (IntObject dat : this._iterations) {
                if (count != 0) {
                    sb.append(",");
                }
                String tmp = String.valueOf(dat.getLongValue());
                for (int k = tmp.length(); k < maxDigits; ++k) {
                    sb.append("0");
                }
                sb.append(tmp);
                ++count;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public static Task parseCompactString(String stask) {
        StringTokenizer st = new StringTokenizer(stask.trim(), ".");
        TaskType type = TaskType.valueOf(st.nextToken());
        String meta = st.nextToken();
        Task newTask = new Task(meta, type);
        String sdata = st.nextToken();
        sdata = sdata.substring(1, sdata.length() - 1);
        StringTokenizer st2 = new StringTokenizer(sdata, ",");
        while (st2.hasMoreTokens()) {
            String lsdata = st2.nextToken();
            IntObject ldata = new IntObject(Integer.parseInt(lsdata));
            newTask.addIteration(ldata);
        }
        return newTask;
    }

    public static enum TaskType {
        RANGE,
        SET;

    }
}

