/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor;

import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMergeRemoteSparkWCompare;
import org.tugraz.sysds.runtime.instructions.spark.data.RDDObject;
import org.tugraz.sysds.runtime.instructions.spark.functions.CopyMatrixBlockPairFunction;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.utils.Statistics;

public class ResultMergeRemoteSpark
extends ResultMerge {
    private static final long serialVersionUID = -6924566953903424820L;
    private ExecutionContext _ec = null;
    private int _numMappers = -1;
    private int _numReducers = -1;

    public ResultMergeRemoteSpark(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum, ExecutionContext ec, int numMappers, int numReducers) {
        super(out, in, outputFilename, accum);
        this._ec = ec;
        this._numMappers = numMappers;
        this._numReducers = numReducers;
    }

    @Override
    public MatrixObject executeSerialMerge() {
        return this.executeParallelMerge(this._numMappers);
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (remote, spark): Execute serial merge for output " + this._output.hashCode() + " (fname=" + this._output.getFileName() + ")"));
        }
        try {
            if (this._inputs != null && this._inputs.length > 0) {
                MetaDataFormat metadata = (MetaDataFormat)this._output.getMetaData();
                DataCharacteristics mcOld = metadata.getDataCharacteristics();
                MatrixObject compare = mcOld.getNonZeros() == 0L ? null : this._output;
                RDDObject ro = this.executeMerge(compare, this._inputs, mcOld.getRows(), mcOld.getCols(), mcOld.getBlocksize());
                moNew = new MatrixObject(this._output.getValueType(), this._outputFName);
                OutputInfo oiOld = metadata.getOutputInfo();
                InputInfo iiOld = metadata.getInputInfo();
                MatrixCharacteristics mc = new MatrixCharacteristics(mcOld);
                ((DataCharacteristics)mc).setNonZeros(this._isAccum ? -1L : this.computeNonZeros(this._output, Arrays.asList(this._inputs)));
                MetaDataFormat meta = new MetaDataFormat(mc, oiOld, iiOld);
                moNew.setMetaData(meta);
                moNew.setRDDHandle(ro);
            } else {
                moNew = this._output;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    protected RDDObject executeMerge(MatrixObject compare, MatrixObject[] inputs, long rlen, long clen, int blen) {
        String jobname = "ParFor-RMSP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)this._ec;
        boolean withCompare = compare != null;
        RDDObject ret = null;
        int numRed = ResultMergeRemoteSpark.determineNumReducers(rlen, clen, blen, this._numReducers);
        if (inputs == null || inputs.length == 0) {
            throw new DMLRuntimeException("Execute merge should never be called with no inputs.");
        }
        try {
            InputInfo ii = InputInfo.BinaryBlockInputInfo;
            JobConf job = new JobConf("test");
            job.setJobName(jobname);
            job.setInputFormat(ii.inputFormatClass);
            Path[] paths = new Path[inputs.length];
            for (int i = 0; i < paths.length; ++i) {
                inputs[i].exportData();
                paths[i] = new Path(inputs[i].getFileName());
                ResultMergeRemoteSpark.setRDDHandleForMerge(inputs[i], sec);
            }
            FileInputFormat.setInputPaths((JobConf)job, (Path[])paths);
            JavaPairRDD rdd = sec.getSparkContext().hadoopRDD(job, ii.inputFormatClass, ii.inputKeyClass, ii.inputValueClass).mapPartitionsToPair((PairFlatMapFunction)new CopyMatrixBlockPairFunction(true), true);
            JavaPairRDD out = null;
            if (withCompare) {
                JavaPairRDD<?, ?> compareRdd = sec.getRDDHandleForMatrixObject(compare, InputInfo.BinaryBlockInputInfo);
                ResultMergeRemoteSparkWCompare cfun = new ResultMergeRemoteSparkWCompare(this._isAccum);
                out = rdd.groupByKey(numRed).join(compareRdd).mapToPair((PairFunction)cfun);
            } else {
                out = this._isAccum ? RDDAggregateUtils.sumByKeyStable((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd, false) : RDDAggregateUtils.mergeByKey((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd, false);
            }
            ret = new RDDObject(out);
            for (int i = 0; i < paths.length; ++i) {
                ret.addLineageChild(inputs[i].getRDDHandle());
            }
            if (withCompare) {
                ret.addLineageChild(compare.getRDDHandle());
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
        return ret;
    }

    private static int determineNumReducers(long rlen, long clen, int blen, long numRed) {
        long reducerGroups = Math.max(rlen / (long)blen, 1L) * Math.max(clen / (long)blen, 1L);
        return (int)Math.min(numRed, reducerGroups);
    }

    private static void setRDDHandleForMerge(MatrixObject mo, SparkExecutionContext sec) {
        InputInfo iinfo = InputInfo.BinaryBlockInputInfo;
        JavaPairRDD rdd = sec.getSparkContext().hadoopFile(mo.getFileName(), iinfo.inputFormatClass, iinfo.inputKeyClass, iinfo.inputValueClass);
        RDDObject rddhandle = new RDDObject(rdd);
        rddhandle.setHDFSFile(true);
        mo.setRDDHandle(rddhandle);
    }
}

