/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.runtime.util.DataConverter;

public class ResultMergeLocalMemory
extends ResultMerge {
    private static final long serialVersionUID = -3543612508601511701L;
    private DenseBlock _compare = null;

    public ResultMergeLocalMemory(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, in-memory): Execute serial merge for output " + this._output.hashCode() + " (fname=" + this._output.getFileName() + ")"));
        }
        try {
            MatrixBlock outMB = this._output.acquireRead();
            long estnnz = this.getOutputNnzEstimate();
            MatrixBlock outMBNew = new MatrixBlock(outMB.getNumRows(), outMB.getNumColumns(), estnnz).allocateBlock();
            boolean appendOnly = outMBNew.isInSparseFormat();
            this._compare = ResultMergeLocalMemory.getCompareMatrix(outMB);
            if (this._compare != null) {
                outMBNew.copy(outMB);
            }
            boolean flagMerged = false;
            for (MatrixObject in : this._inputs) {
                boolean sparseToDense;
                if (in == null || in == this._output) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, in-memory): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                MatrixBlock inMB = in.acquireRead();
                this.merge(outMBNew, inMB, appendOnly);
                in.release();
                in.clearData();
                flagMerged = true;
                boolean bl = sparseToDense = appendOnly && !MatrixBlock.evalSparseFormatInMemory(outMBNew.getNumRows(), outMBNew.getNumColumns(), outMBNew.getNonZeros());
                if (!sparseToDense) continue;
                outMBNew.sortSparseRows();
                outMBNew.examSparsity();
                appendOnly = false;
            }
            if (appendOnly && !this._isAccum) {
                outMBNew.sortSparseRows();
            }
            outMBNew.examSparsity();
            moNew = flagMerged ? this.createNewMatrixObject(outMBNew) : this._output;
            this._output.release();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, in-memory): Execute parallel (par=" + par + ") merge for output " + this._output.hashCode() + " (fname=" + this._output.getFileName() + ")"));
        }
        try {
            MatrixBlock outMB = this._output.acquireRead();
            ArrayList<MatrixObject> inMO = new ArrayList<MatrixObject>();
            for (MatrixObject in : this._inputs) {
                if (in == null || in == this._output) continue;
                inMO.add(in);
            }
            if (!inMO.isEmpty()) {
                long rows = outMB.getNumRows();
                long cols = outMB.getNumColumns();
                MatrixBlock outMBNew = new MatrixBlock((int)rows, (int)cols, false);
                outMBNew.allocateDenseBlockUnsafe((int)rows, (int)cols);
                this._compare = ResultMergeLocalMemory.getCompareMatrix(outMB);
                if (this._compare != null) {
                    outMBNew.copy(outMB);
                }
                int numThreads = Math.min(par, inMO.size());
                numThreads = Math.min(numThreads, InfrastructureAnalyzer.getLocalParallelism());
                Thread[] threads = new Thread[numThreads];
                for (int k = 0; k < inMO.size(); k += numThreads) {
                    int i;
                    for (i = 0; i < threads.length; ++i) {
                        ResultMergeWorker rmw = new ResultMergeWorker((MatrixObject)inMO.get(k + i), outMBNew);
                        threads[i] = new Thread(rmw);
                        threads[i].setPriority(10);
                        threads[i].start();
                    }
                    for (i = 0; i < threads.length; ++i) {
                        threads[i].join();
                    }
                }
                moNew = this.createNewMatrixObject(outMBNew);
            } else {
                moNew = this._output;
            }
            this._output.release();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    private static DenseBlock getCompareMatrix(MatrixBlock output) {
        if (!output.isEmptyBlock(false)) {
            return DataConverter.convertToDenseBlock(output, false);
        }
        return null;
    }

    private MatrixObject createNewMatrixObject(MatrixBlock data) {
        Types.ValueType vt = this._output.getValueType();
        MetaDataFormat metadata = (MetaDataFormat)this._output.getMetaData();
        MatrixObject moNew = new MatrixObject(vt, this._outputFName);
        DataCharacteristics mcOld = metadata.getDataCharacteristics();
        OutputInfo oiOld = metadata.getOutputInfo();
        InputInfo iiOld = metadata.getInputInfo();
        MatrixCharacteristics mc = new MatrixCharacteristics(mcOld.getRows(), mcOld.getCols(), mcOld.getBlocksize());
        mc.setNonZeros(data.getNonZeros());
        MetaDataFormat meta = new MetaDataFormat(mc, oiOld, iiOld);
        moNew.setMetaData(meta);
        data.examSparsity();
        moNew.acquireModify(data);
        moNew.release();
        return moNew;
    }

    private void merge(MatrixBlock out, MatrixBlock in, boolean appendOnly) {
        if (this._compare == null) {
            this.mergeWithoutComp(out, in, appendOnly, true);
        } else {
            this.mergeWithComp(out, in, this._compare);
        }
    }

    private long getOutputNnzEstimate() {
        long nnzInputs = 0L;
        for (MatrixObject input : this._inputs) {
            if (input == null) continue;
            nnzInputs += Math.max(input.getNnz(), 1L);
        }
        long rlen = this._output.getNumRows();
        long clen = this._output.getNumColumns();
        return Math.min(rlen * clen, Math.max(nnzInputs, this._output.getNnz()));
    }

    private class ResultMergeWorker
    implements Runnable {
        private MatrixObject _inMO = null;
        private MatrixBlock _outMB = null;

        public ResultMergeWorker(MatrixObject inMO, MatrixBlock outMB) {
            this._inMO = inMO;
            this._outMB = outMB;
        }

        @Override
        public void run() {
            try {
                ResultMerge.LOG.trace((Object)("ResultMerge (local, in-memory): Merge input " + this._inMO.hashCode() + " (fname=" + this._inMO.getFileName() + ")"));
                MatrixBlock inMB = this._inMO.acquireRead();
                ResultMergeLocalMemory.this.merge(this._outMB, inMB, false);
                this._inMO.release();
                this._inMO.clearData();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to parallel merge result.", ex);
            }
        }
    }
}

