/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.parfor;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.ParForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitioner;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitionerRemoteSparkMapper;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitionerRemoteSparkReducer;
import org.tugraz.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.util.HDFSTool;
import org.tugraz.sysds.utils.Statistics;

public class DataPartitionerRemoteSpark
extends DataPartitioner {
    private final ExecutionContext _ec;
    private final long _numRed;
    private final int _replication;

    public DataPartitionerRemoteSpark(ParForProgramBlock.PartitionFormat dpf, ExecutionContext ec, long numRed, int replication, boolean keepIndexes) {
        super(dpf._dpf, dpf._N);
        this._ec = ec;
        this._numRed = numRed;
        this._replication = replication;
    }

    @Override
    protected void partitionMatrix(MatrixObject in, String fnameNew, InputInfo ii, OutputInfo oi, long rlen, long clen, int blen) {
        String jobname = "ParFor-DPSP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)this._ec;
        try {
            HDFSTool.deleteFileIfExistOnHDFS(fnameNew);
            JavaPairRDD<?, ?> inRdd = sec.getRDDHandleForMatrixObject(in, InputInfo.BinaryBlockInputInfo);
            DataCharacteristics mc = in.getDataCharacteristics();
            int numRed = (int)this.determineNumReducers(inRdd, mc, this._numRed);
            DataPartitionerRemoteSparkMapper dpfun = new DataPartitionerRemoteSparkMapper(mc, ii, oi, this._format, this._n);
            DataPartitionerRemoteSparkReducer wfun = new DataPartitionerRemoteSparkReducer(fnameNew, oi, this._replication);
            inRdd.flatMapToPair((PairFlatMapFunction)dpfun).groupByKey(numRed).foreach((VoidFunction)wfun);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
    }

    private long determineNumReducers(JavaPairRDD<MatrixIndexes, MatrixBlock> in, DataCharacteristics mc, long numRed) {
        long rlen = mc.getRows();
        long clen = mc.getCols();
        int blen = mc.getBlocksize();
        long reducerGroups = -1L;
        switch (this._format) {
            case ROW_WISE: {
                reducerGroups = rlen;
                break;
            }
            case COLUMN_WISE: {
                reducerGroups = clen;
                break;
            }
            case ROW_BLOCK_WISE: {
                reducerGroups = rlen / (long)blen + (long)(rlen % (long)blen == 0L ? 0 : 1);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                reducerGroups = clen / (long)blen + (long)(clen % (long)blen == 0L ? 0 : 1);
                break;
            }
            case ROW_BLOCK_WISE_N: {
                reducerGroups = rlen / (long)this._n + (long)(rlen % (long)this._n == 0L ? 0 : 1);
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                reducerGroups = clen / (long)this._n + (long)(clen % (long)this._n == 0L ? 0 : 1);
                break;
            }
        }
        int numParts = SparkUtils.getNumPreferredPartitions(mc, in);
        return Math.max(numRed, Math.min((long)numParts, reducerGroups));
    }
}

