/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.paramserv.rpc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheDataOutput;
import org.tugraz.sysds.runtime.controlprogram.paramserv.rpc.PSRpcObject;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.util.ByteBufferDataInput;

public class PSRpcResponse
extends PSRpcObject {
    private Type _status;
    private Object _data;

    public PSRpcResponse(ByteBuffer buffer) throws IOException {
        this.deserialize(buffer);
    }

    public PSRpcResponse(Type status) {
        this(status, null);
    }

    public PSRpcResponse(Type status, Object data) {
        this._status = status;
        this._data = data;
        if (this._status == Type.SUCCESS && data == null) {
            this._status = Type.SUCCESS_EMPTY;
        }
    }

    public boolean isSuccessful() {
        return this._status != Type.ERROR;
    }

    public String getErrorMessage() {
        return (String)this._data;
    }

    public ListObject getResultModel() {
        return (ListObject)this._data;
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IOException {
        ByteBufferDataInput dis = new ByteBufferDataInput(buffer);
        this._status = Type.values()[dis.readInt()];
        switch (this._status) {
            case SUCCESS: {
                this._data = this.readAndDeserialize(dis);
                break;
            }
            case SUCCESS_EMPTY: {
                break;
            }
            case ERROR: {
                this._data = dis.readUTF();
            }
        }
    }

    @Override
    public ByteBuffer serialize() throws IOException {
        int len = 4 + (this._status == Type.SUCCESS ? this.getExactSerializedSize((ListObject)this._data) : (this._status == Type.SUCCESS_EMPTY ? 0 : IOUtilFunctions.getUTFSize((String)this._data)));
        CacheDataOutput dos = new CacheDataOutput(len);
        dos.writeInt(this._status.ordinal());
        switch (this._status) {
            case SUCCESS: {
                this.serializeAndWriteListObject((ListObject)this._data, dos);
                break;
            }
            case SUCCESS_EMPTY: {
                break;
            }
            case ERROR: {
                dos.writeUTF(this._data.toString());
            }
        }
        return ByteBuffer.wrap(dos.getBytes());
    }

    public static enum Type {
        SUCCESS,
        SUCCESS_EMPTY,
        ERROR;

    }
}

