/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.paramserv.rpc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.paramserv.LocalParamServer;
import org.tugraz.sysds.runtime.controlprogram.paramserv.rpc.PSRpcCall;
import org.tugraz.sysds.runtime.controlprogram.paramserv.rpc.PSRpcResponse;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;

public final class PSRpcHandler
extends RpcHandler {
    private LocalParamServer _server;

    protected PSRpcHandler(LocalParamServer server) {
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void receive(TransportClient client, ByteBuffer buffer, RpcResponseCallback callback) {
        PSRpcCall call;
        try {
            call = new PSRpcCall(buffer);
        }
        catch (IOException e) {
            throw new DMLRuntimeException("PSRpcHandler: some error occurred when deserializing the rpc call.", e);
        }
        PSRpcResponse response = null;
        switch (call.getMethod()) {
            case 1: {
                this._server.push(call.getWorkerID(), call.getData());
                response = new PSRpcResponse(PSRpcResponse.Type.SUCCESS_EMPTY);
                try {
                    callback.onSuccess(response.serialize());
                    break;
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                }
                catch (DMLRuntimeException exception) {
                    try {
                        response = new PSRpcResponse(PSRpcResponse.Type.ERROR, ExceptionUtils.getFullStackTrace((Throwable)exception));
                    }
                    catch (Throwable throwable) {
                        try {
                            callback.onSuccess(response.serialize());
                        }
                        catch (IOException e) {
                            throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                        }
                        throw throwable;
                    }
                    try {
                        callback.onSuccess(response.serialize());
                        break;
                    }
                    catch (IOException e) {
                        throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                    }
                }
            }
            case 2: {
                ListObject data = this._server.pull(call.getWorkerID());
                response = new PSRpcResponse(PSRpcResponse.Type.SUCCESS, data);
                try {
                    callback.onSuccess(response.serialize());
                    break;
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                }
                catch (DMLRuntimeException exception) {
                    try {
                        response = new PSRpcResponse(PSRpcResponse.Type.ERROR, ExceptionUtils.getFullStackTrace((Throwable)exception));
                    }
                    catch (Throwable throwable) {
                        try {
                            callback.onSuccess(response.serialize());
                        }
                        catch (IOException e) {
                            throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                        }
                        throw throwable;
                    }
                    try {
                        callback.onSuccess(response.serialize());
                        break;
                    }
                    catch (IOException e) {
                        throw new DMLRuntimeException("PSRpcHandler: some error occrred when wrapping the rpc response.", e);
                    }
                }
            }
            default: {
                throw new DMLRuntimeException(String.format("Does not support the rpc call for method %s", call.getMethod()));
            }
        }
    }

    public StreamManager getStreamManager() {
        return new OneForOneStreamManager();
    }
}

