/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.paramserv.dp;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.tugraz.sysds.runtime.controlprogram.paramserv.dp.DataPartitionLocalScheme;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.DataConverter;

public class DRRLocalScheme
extends DataPartitionLocalScheme {
    public static MatrixBlock removeEmpty(MatrixBlock mb, int k, int workerId) {
        double[] data = LongStream.range(0L, mb.getNumRows()).mapToDouble(l -> l % (long)k == (long)workerId ? 1.0 : 0.0).toArray();
        MatrixBlock select = DataConverter.convertToMatrixBlock(data, true);
        return mb.removeEmptyOperations(new MatrixBlock(), true, true, select);
    }

    private static MatrixObject internalRemoveEmpty(MatrixBlock mb, int k, int workerId) {
        MatrixObject result = ParamservUtils.newMatrixObject(DRRLocalScheme.removeEmpty(mb, k, workerId));
        result.enableCleanup(false);
        return result;
    }

    @Override
    public DataPartitionLocalScheme.Result doPartitioning(int workersNum, MatrixBlock features, MatrixBlock labels) {
        List<MatrixObject> pfs = IntStream.range(0, workersNum).mapToObj(i -> DRRLocalScheme.internalRemoveEmpty(features, workersNum, i)).collect(Collectors.toList());
        List<MatrixObject> pls = IntStream.range(0, workersNum).mapToObj(i -> DRRLocalScheme.internalRemoveEmpty(labels, workersNum, i)).collect(Collectors.toList());
        return new DataPartitionLocalScheme.Result(pfs, pls);
    }
}

