/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.paramserv.dp;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.tugraz.sysds.runtime.controlprogram.paramserv.dp.DataPartitionLocalScheme;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class DRLocalScheme
extends DataPartitionLocalScheme {
    private static List<MatrixBlock> partition(int k, MatrixBlock mb, MatrixBlock permutation) {
        int batchSize = (int)Math.ceil((double)mb.getNumRows() / (double)k);
        return IntStream.range(0, k).mapToObj(i -> {
            int begin = i * batchSize;
            int end = Math.min((i + 1) * batchSize, mb.getNumRows());
            MatrixBlock slicedPerm = permutation.slice(begin, end - 1);
            return slicedPerm.aggregateBinaryOperations(slicedPerm, mb, new MatrixBlock(), InstructionUtils.getMatMultOperator(k));
        }).collect(Collectors.toList());
    }

    private static List<MatrixObject> internalDoPartitioning(int k, MatrixBlock mb, MatrixBlock permutation) {
        return DRLocalScheme.partition(k, mb, permutation).stream().map(ParamservUtils::newMatrixObject).collect(Collectors.toList());
    }

    @Override
    public DataPartitionLocalScheme.Result doPartitioning(int workersNum, MatrixBlock features, MatrixBlock labels) {
        MatrixBlock permutation = ParamservUtils.generatePermutation(features.getNumRows(), ParamservUtils.SEED);
        List<MatrixObject> pfs = DRLocalScheme.internalDoPartitioning(workersNum, features, permutation);
        List<MatrixObject> pls = DRLocalScheme.internalDoPartitioning(workersNum, labels, permutation);
        return new DataPartitionLocalScheme.Result(this, pfs, pls);
    }
}

