/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.federated;

import java.util.Map;
import java.util.TreeMap;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRange;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;

public class LibFederatedAppend {
    public static MatrixObject federateAppend(MatrixObject matObject1, MatrixObject matObject2, MatrixObject matObjectRet, boolean cbind) {
        TreeMap<FederatedRange, FederatedData> fedMapping = new TreeMap<FederatedRange, FederatedData>();
        DataCharacteristics dc = matObjectRet.getDataCharacteristics();
        if (cbind) {
            dc.setRows(matObject1.getNumRows());
            long columnsLeftMat = matObject1.getNumColumns();
            dc.setCols(columnsLeftMat + matObject2.getNumColumns());
            Map<FederatedRange, FederatedData> fedMappingLeft = matObject1.getFedMapping();
            for (Map.Entry<FederatedRange, FederatedData> entry : fedMappingLeft.entrySet()) {
                fedMapping.put(new FederatedRange(entry.getKey()), entry.getValue());
            }
            Map<FederatedRange, FederatedData> fedMappingRight = matObject2.getFedMapping();
            for (Map.Entry<FederatedRange, FederatedData> entry : fedMappingRight.entrySet()) {
                FederatedRange range = new FederatedRange(entry.getKey());
                range.setBeginDim(1, columnsLeftMat + range.getBeginDims()[1]);
                range.setEndDim(1, columnsLeftMat + range.getEndDims()[1]);
                fedMapping.put(range, entry.getValue());
            }
        } else {
            dc.setCols(matObject1.getNumColumns());
            long rowsUpperMat = matObject1.getNumRows();
            dc.setRows(rowsUpperMat + matObject2.getNumRows());
            Map<FederatedRange, FederatedData> fedMappingUpper = matObject1.getFedMapping();
            for (Map.Entry<FederatedRange, FederatedData> entry : fedMappingUpper.entrySet()) {
                fedMapping.put(new FederatedRange(entry.getKey()), entry.getValue());
            }
            Map<FederatedRange, FederatedData> fedMappingLower = matObject2.getFedMapping();
            for (Map.Entry<FederatedRange, FederatedData> entry : fedMappingLower.entrySet()) {
                FederatedRange range = new FederatedRange(entry.getKey());
                range.setBeginDim(0, rowsUpperMat + range.getBeginDims()[0]);
                range.setEndDim(0, rowsUpperMat + range.getEndDims()[0]);
                fedMapping.put(range, entry.getValue());
            }
        }
        matObjectRet.setFedMapping(fedMapping);
        dc.setNonZeros(matObject1.getNnz() + matObject2.getNnz());
        return matObjectRet;
    }
}

