/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.federated;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRange;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.tugraz.sysds.runtime.functionobjects.KahanFunction;
import org.tugraz.sysds.runtime.functionobjects.ValueFunction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixValue;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;

public class LibFederatedAgg {
    public static MatrixBlock aggregateUnaryMatrix(MatrixObject federatedMatrix, AggregateUnaryOperator operator) {
        MatrixCharacteristics mc = new MatrixCharacteristics();
        operator.indexFn.computeDimension(federatedMatrix.getDataCharacteristics(), mc);
        MatrixBlock ret = new MatrixBlock((int)mc.getRows(), (int)mc.getCols(), operator.aggOp.initialValue);
        ArrayList<ImmutablePair> idResponsePairs = new ArrayList<ImmutablePair>();
        for (Map.Entry<FederatedRange, FederatedData> entry : federatedMatrix.getFedMapping().entrySet()) {
            FederatedData fedData = entry.getValue();
            if (!fedData.isInitialized()) {
                throw new DMLRuntimeException("Not all FederatedData was initialized for federated matrix");
            }
            Future<FederatedResponse> future = fedData.executeFederatedOperation(new FederatedRequest(FederatedRequest.FedMethod.AGGREGATE, operator), true);
            idResponsePairs.add(new ImmutablePair((Object)entry.getKey(), future));
        }
        try {
            for (Pair pair : idResponsePairs) {
                FederatedRange range = (FederatedRange)pair.getLeft();
                FederatedResponse federatedResponse = (FederatedResponse)((Future)pair.getRight()).get();
                int[] beginDims = range.getBeginDimsInt();
                if (!federatedResponse.isSuccessful()) {
                    throw new DMLRuntimeException("Federated aggregation failed: " + federatedResponse.getErrorMessage());
                }
                MatrixBlock mb = (MatrixBlock)federatedResponse.getData();
                MatrixValue.CellIndex cellIndex = new MatrixValue.CellIndex(0, 0);
                ValueFunction valueFn = operator.aggOp.increOp.fn;
                for (int r = 0; r < mb.getNumRows(); ++r) {
                    for (int c = 0; c < mb.getNumColumns(); ++c) {
                        double newValue;
                        cellIndex.set(r + beginDims[0], c + beginDims[1]);
                        operator.indexFn.execute(cellIndex, cellIndex);
                        int resultRow = cellIndex.row;
                        int resultCol = cellIndex.column;
                        if (valueFn instanceof KahanFunction) {
                            KahanObject kobj = new KahanObject(ret.quickGetValue(resultRow, resultCol), 0.0);
                            newValue = ((KahanObject)valueFn.execute((Data)kobj, (double)mb.quickGetValue((int)r, (int)c)))._sum;
                        } else {
                            newValue = valueFn.execute(ret.quickGetValue(resultRow, resultCol), mb.quickGetValue(r, c));
                        }
                        ret.quickSetValue(resultRow, resultCol, newValue);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Federated binary aggregation failed", e);
        }
        return ret;
    }
}

