/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.federated;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedWorkerHandler;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDSequence;

public class FederatedWorker {
    protected static Logger log = Logger.getLogger(FederatedWorker.class);
    private int _port;
    private int _nrThreads = Integer.parseInt("1");
    private IDSequence _seq = new IDSequence();
    private Map<Long, CacheableData<?>> _vars = new HashMap();

    public FederatedWorker(int port) {
        this._port = port == -1 ? Integer.parseInt("4040") : port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info((Object)"Setting up Federated Worker");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this._nrThreads);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this._nrThreads);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast("ObjectDecoder", (ChannelHandler)new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.weakCachingResolver((ClassLoader)ClassLoader.getSystemClassLoader()))).addLast("ObjectEncoder", (ChannelHandler)new ObjectEncoder()).addLast("FederatedWorkerHandler", (ChannelHandler)new FederatedWorkerHandler(FederatedWorker.this._seq, FederatedWorker.this._vars));
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            log.info((Object)("Starting Federated Worker server at port: " + this._port));
            ChannelFuture f = b.bind(this._port).sync();
            log.info((Object)("Started Federated Worker at port: " + this._port));
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error((Object)"Federated worker interrupted");
        }
        finally {
            log.info((Object)"Federated Worker Shutting down.");
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

