/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.federated;

import java.util.Arrays;

public class FederatedRange
implements Comparable<FederatedRange> {
    private long[] _beginDims;
    private long[] _endDims;

    public FederatedRange(long[] beginDims, long[] endDims) {
        this._beginDims = beginDims;
        this._endDims = endDims;
    }

    public FederatedRange(FederatedRange other) {
        this._beginDims = (long[])other._beginDims.clone();
        this._endDims = (long[])other._endDims.clone();
    }

    public void setBeginDim(int dim, long value) {
        this._beginDims[dim] = value;
    }

    public void setEndDim(int dim, long value) {
        this._endDims[dim] = value;
    }

    public long[] getBeginDims() {
        return this._beginDims;
    }

    public long[] getEndDims() {
        return this._endDims;
    }

    public int[] getBeginDimsInt() {
        return Arrays.stream(this._beginDims).mapToInt(i -> (int)i).toArray();
    }

    public int[] getEndDimsInt() {
        return Arrays.stream(this._endDims).mapToInt(i -> (int)i).toArray();
    }

    public long getSize() {
        long size = 1L;
        for (int i = 0; i < this._beginDims.length; ++i) {
            size *= this._endDims[i] - this._beginDims[i];
        }
        return size;
    }

    @Override
    public int compareTo(FederatedRange o) {
        for (int i = 0; i < this._beginDims.length; ++i) {
            if (this._beginDims[i] < o._beginDims[i]) {
                return -1;
            }
            if (this._beginDims[i] <= o._beginDims[i]) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Arrays.toString(this._beginDims) + " - " + Arrays.toString(this._endDims);
    }
}

