/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.federated;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedResponse;

public class FederatedData {
    private InetSocketAddress _address;
    private String _filepath;
    private long _varID = -1L;
    private int _nrThreads = Integer.parseInt("1");

    public FederatedData(InetSocketAddress address, String filepath) {
        this._address = address;
        this._filepath = filepath;
    }

    public FederatedData(FederatedData other, long varID) {
        this(other._address, other._filepath);
        this._varID = varID;
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setVarID(long varID) {
        this._varID = varID;
    }

    public String getFilepath() {
        return this._filepath;
    }

    public boolean isInitialized() {
        return this._varID != -1L;
    }

    public synchronized Future<FederatedResponse> initFederatedData() {
        if (this.isInitialized()) {
            throw new DMLRuntimeException("Tried to init already initialized data");
        }
        FederatedRequest request = new FederatedRequest(FederatedRequest.FedMethod.READ);
        request.appendParam(this._filepath);
        return this.executeFederatedOperation(request);
    }

    public Future<FederatedResponse> executeFederatedOperation(FederatedRequest request, boolean withVarID) {
        if (withVarID) {
            if (!this.isInitialized()) {
                throw new DMLRuntimeException("Tried to execute federated operation on data non initialized federated data.");
            }
            return this.executeFederatedOperation(request, this._varID);
        }
        return this.executeFederatedOperation(request);
    }

    public Future<FederatedResponse> executeFederatedOperation(FederatedRequest request, long varID) {
        request = request.deepClone();
        request.appendParam(varID);
        return this.executeFederatedOperation(request);
    }

    public synchronized Future<FederatedResponse> executeFederatedOperation(FederatedRequest request) {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this._nrThreads);
        try {
            Bootstrap b = new Bootstrap();
            final DataRequestHandler handler = new DataRequestHandler((EventLoopGroup)workerGroup);
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast("ObjectDecoder", (ChannelHandler)new ObjectDecoder(Integer.MAX_VALUE, ClassResolvers.weakCachingResolver((ClassLoader)ClassLoader.getSystemClassLoader()))).addLast("FederatedOperationHandler", (ChannelHandler)handler).addLast("ObjectEncoder", (ChannelHandler)new ObjectEncoder());
                }
            });
            ChannelFuture f = b.connect((SocketAddress)this._address).sync();
            Promise promise = f.channel().eventLoop().newPromise();
            handler.setPromise((Promise<FederatedResponse>)promise);
            f.channel().writeAndFlush((Object)request);
            return promise;
        }
        catch (InterruptedException e) {
            throw new DMLRuntimeException("Could not send federated operation.");
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static class DataRequestHandler
    extends ChannelInboundHandlerAdapter {
        private Promise<FederatedResponse> _prom;
        private EventLoopGroup _workerGroup;

        public DataRequestHandler(EventLoopGroup workerGroup) {
            this._workerGroup = workerGroup;
        }

        public void setPromise(Promise<FederatedResponse> prom) {
            this._prom = prom;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this._prom == null) {
                throw new DMLRuntimeException("Read while no message was sent");
            }
            this._prom.setSuccess((Object)((FederatedResponse)msg));
            ctx.close();
            this._workerGroup.shutdownGracefully();
        }
    }
}

