/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.instructions.spark.data.RDDObject;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaData;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.runtime.meta.TensorCharacteristics;
import org.tugraz.sysds.runtime.util.DataConverter;

public class TensorObject
extends CacheableData<TensorBlock> {
    private static final long serialVersionUID = -2843358400200380775L;

    protected TensorObject() {
        super(Types.DataType.TENSOR, Types.ValueType.STRING);
    }

    public TensorObject(String fname) {
        this();
        this.setFileName(fname);
    }

    public TensorObject(Types.ValueType vt, String fname) {
        super(Types.DataType.TENSOR, vt);
        this.setFileName(fname);
    }

    public TensorObject(String fname, MetaData meta) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
    }

    public TensorObject(TensorObject fo) {
        super(fo);
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics tc = this._metaData.getDataCharacteristics();
        long[] dims = this._metaData.getDataCharacteristics().getDims();
        tc.setDims(dims);
        tc.setNonZeros(((TensorBlock)this._data).getNonZeros());
    }

    public long getNumRows() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getDim(0);
    }

    public long getNumColumns() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getDim(1);
    }

    public long getNnz() {
        return this.getDataCharacteristics().getNonZeros();
    }

    @Override
    protected TensorBlock readBlobFromCache(String fname) throws IOException {
        return (TensorBlock)LazyWriteBuffer.readBlock(fname, false);
    }

    @Override
    protected TensorBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading tensor from HDFS...  " + this.hashCode() + "  Path: " + fname + ", dimensions: " + Arrays.toString(dims)));
            begin = System.currentTimeMillis();
        }
        int blen = dc.getBlocksize();
        TensorBlock newData = DataConverter.readTensorFromHDFS(fname, iimd.getInputInfo(), dims, blen, this.getSchema());
        this.setHDFSFileExists(true);
        if (newData == null) {
            throw new IOException("Unable to load tensor from file: " + fname);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading Completed: " + (System.currentTimeMillis() - begin) + " msec."));
        }
        return newData;
    }

    @Override
    protected TensorBlock readBlobFromRDD(RDDObject rdd, MutableBoolean status) {
        status.setValue(false);
        TensorCharacteristics tc = (TensorCharacteristics)this._metaData.getDataCharacteristics();
        return SparkExecutionContext.toTensorBlock(rdd.getRDD(), tc);
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Writing tensor to HDFS...  " + this.hashCode() + "  Path: " + fname + ", Format: " + (ofmt != null ? ofmt : "inferred from metadata")));
            begin = System.currentTimeMillis();
        }
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        if (this._data != null) {
            DataCharacteristics dc = iimd.getDataCharacteristics();
            OutputInfo oinfo = ofmt != null ? OutputInfo.stringToOutputInfo(ofmt) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
            DataConverter.writeTensorToHDFS((TensorBlock)this._data, fname, oinfo, dc);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing tensor to HDFS (" + fname + ") - COMPLETED... " + (System.currentTimeMillis() - begin) + " msec."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writing tensor to HDFS (" + fname + ") - NOTHING TO WRITE (_data == null)."));
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementHDFSWrites();
        }
    }

    @Override
    protected Types.ValueType[] getSchema() {
        return ((TensorBlock)this._data).getSchema();
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String ofmt) throws DMLRuntimeException {
    }
}

