/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.ParForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRange;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.tugraz.sysds.runtime.instructions.spark.data.RDDObject;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaData;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.runtime.util.DataConverter;
import org.tugraz.sysds.runtime.util.HDFSTool;
import org.tugraz.sysds.runtime.util.IndexRange;

public class MatrixObject
extends CacheableData<MatrixBlock> {
    private static final long serialVersionUID = 6374712373206495637L;
    private UpdateType _updateType = UpdateType.COPY;
    private boolean _diag = false;
    private boolean _markForLinCache = false;
    private boolean _partitioned = false;
    private ParForProgramBlock.PDataPartitionFormat _partitionFormat = null;
    private int _partitionSize = -1;
    private String _partitionCacheName = null;
    private MatrixBlock _partitionInMemory = null;
    private Map<FederatedRange, FederatedData> _fedMapping = null;

    public MatrixObject(Types.ValueType vt, String file) {
        this(vt, file, null);
    }

    public MatrixObject(Types.ValueType vt, String file, MetaData mtd) {
        super(Types.DataType.MATRIX, vt);
        this._metaData = mtd;
        this._hdfsFileName = file;
        this._cache = null;
        this._data = null;
    }

    public MatrixObject(MatrixObject mo) {
        super(mo);
        MetaDataFormat metaOld = (MetaDataFormat)mo.getMetaData();
        this._metaData = new MetaDataFormat(new MatrixCharacteristics(metaOld.getDataCharacteristics()), metaOld.getOutputInfo(), metaOld.getInputInfo());
        this._updateType = mo._updateType;
        this._diag = mo._diag;
        this._partitioned = mo._partitioned;
        this._partitionFormat = mo._partitionFormat;
        this._partitionSize = mo._partitionSize;
        this._partitionCacheName = mo._partitionCacheName;
        this._markForLinCache = mo._markForLinCache;
    }

    public boolean isFederated() {
        return this._fedMapping != null;
    }

    public Map<FederatedRange, FederatedData> getFedMapping() {
        return this._fedMapping;
    }

    public void setFedMapping(Map<FederatedRange, FederatedData> fedMapping) {
        this._fedMapping = fedMapping;
    }

    @Override
    public MatrixBlock acquireRead() {
        FederatedRange range;
        if (!this.isFederated()) {
            return (MatrixBlock)super.acquireRead();
        }
        long[] dims = this.getDataCharacteristics().getDims();
        MatrixBlock result = new MatrixBlock((int)dims[0], (int)dims[1], false);
        ArrayList<ImmutablePair> readResponses = new ArrayList<ImmutablePair>();
        for (Map.Entry<FederatedRange, FederatedData> entry : this._fedMapping.entrySet()) {
            range = entry.getKey();
            FederatedData fd = entry.getValue();
            if (fd.isInitialized()) {
                FederatedRequest request = new FederatedRequest(FederatedRequest.FedMethod.TRANSFER);
                Future<FederatedResponse> readResponse = fd.executeFederatedOperation(request, true);
                readResponses.add(new ImmutablePair((Object)range, readResponse));
                continue;
            }
            throw new DMLRuntimeException("Federated matrix read only supported on initialized FederatedData");
        }
        try {
            for (Pair pair : readResponses) {
                range = (FederatedRange)pair.getLeft();
                FederatedResponse response = (FederatedResponse)((Future)pair.getRight()).get();
                int[] beginDimsInt = range.getBeginDimsInt();
                int[] endDimsInt = range.getEndDimsInt();
                if (!response.isSuccessful()) {
                    throw new DMLRuntimeException("Federated matrix read failed: " + response.getErrorMessage());
                }
                MatrixBlock multRes = (MatrixBlock)response.getData();
                result.copy(beginDimsInt[0], endDimsInt[0] - 1, beginDimsInt[1], endDimsInt[1] - 1, multRes, false);
                result.setNonZeros(result.getNonZeros() + multRes.getNonZeros());
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Federated matrix read failed.", e);
        }
        this.acquireModify(result);
        return result;
    }

    public void setUpdateType(UpdateType flag) {
        this._updateType = flag;
    }

    public UpdateType getUpdateType() {
        return this._updateType;
    }

    public boolean isDiag() {
        return this._diag;
    }

    public void setDiag(boolean diag) {
        this._diag = diag;
    }

    public void setMarkForLinCache(boolean mark) {
        this._markForLinCache = mark;
    }

    public boolean isMarked() {
        return this._markForLinCache;
    }

    @Override
    public void updateDataCharacteristics(DataCharacteristics dc) {
        this._metaData.getDataCharacteristics().set(dc);
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics mc = this._metaData.getDataCharacteristics();
        mc.setDimension(((MatrixBlock)this._data).getNumRows(), ((MatrixBlock)this._data).getNumColumns());
        mc.setNonZeros(((MatrixBlock)this._data).getNonZeros());
    }

    public long getNumRows() {
        return this.getDataCharacteristics().getRows();
    }

    public long getNumColumns() {
        return this.getDataCharacteristics().getCols();
    }

    public long getBlocksize() {
        return this.getDataCharacteristics().getBlocksize();
    }

    public long getNnz() {
        return this.getDataCharacteristics().getNonZeros();
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this.getDataCharacteristics());
    }

    public void setPartitioned(ParForProgramBlock.PDataPartitionFormat format, int n) {
        this._partitioned = true;
        this._partitionFormat = format;
        this._partitionSize = n;
    }

    public void unsetPartitioned() {
        this._partitioned = false;
        this._partitionFormat = null;
        this._partitionSize = -1;
    }

    public boolean isPartitioned() {
        return this._partitioned;
    }

    public ParForProgramBlock.PDataPartitionFormat getPartitionFormat() {
        return this._partitionFormat;
    }

    public int getPartitionSize() {
        return this._partitionSize;
    }

    public synchronized void setInMemoryPartition(MatrixBlock block) {
        this._partitionInMemory = block;
    }

    public synchronized MatrixBlock readMatrixPartition(IndexRange pred) {
        long t0;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Acquire partition " + this.hashCode() + " " + pred));
        }
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (!this._partitioned) {
            throw new DMLRuntimeException("MatrixObject not available to indexed read.");
        }
        if (this._partitionInMemory != null) {
            return this._partitionInMemory;
        }
        MatrixBlock mb = null;
        try {
            boolean blockwise = this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE || this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE;
            MetaDataFormat iimd = (MetaDataFormat)this._metaData;
            DataCharacteristics mc = iimd.getDataCharacteristics();
            int blen = mc.getBlocksize();
            String fname = this.getPartitionFileName(pred, blen);
            if (blockwise && this._partitionCacheName != null && this._partitionCacheName.equals(fname)) {
                mb = (MatrixBlock)this._cache.get();
            }
            if (mb == null) {
                long rows = -1L;
                long cols = -1L;
                switch (this._partitionFormat) {
                    case ROW_WISE: {
                        rows = 1L;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE: {
                        rows = blen;
                        cols = mc.getCols();
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        rows = this._partitionSize;
                        cols = mc.getCols();
                        break;
                    }
                    case COLUMN_WISE: {
                        rows = mc.getRows();
                        cols = 1L;
                        break;
                    }
                    case COLUMN_BLOCK_WISE: {
                        rows = mc.getRows();
                        cols = blen;
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        rows = mc.getRows();
                        cols = this._partitionSize;
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported partition format: " + (Object)((Object)this._partitionFormat));
                    }
                }
                if (HDFSTool.existsFileOnHDFS(fname)) {
                    mb = this.readBlobFromHDFS(fname, new long[]{rows, cols});
                } else {
                    mb = new MatrixBlock((int)rows, (int)cols, true);
                    LOG.warn((Object)("Reading empty matrix partition " + fname));
                }
            }
            if (blockwise) {
                this._partitionCacheName = fname;
                this._cache = new SoftReference<Object>(mb);
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
                    int rix = (int)((pred.rowStart - 1L) % (long)blen);
                    mb = mb.slice(rix, rix, (int)(pred.colStart - 1L), (int)(pred.colEnd - 1L), new MatrixBlock());
                }
                if (this._partitionFormat == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) {
                    int cix = (int)((pred.colStart - 1L) % (long)blen);
                    mb = mb.slice((int)(pred.rowStart - 1L), (int)(pred.rowEnd - 1L), cix, cix, new MatrixBlock());
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            CacheStatistics.incrementAcquireRTime(t1 - t0);
        }
        return mb;
    }

    public String getPartitionFileName(IndexRange pred, int blen) {
        if (!this._partitioned) {
            throw new DMLRuntimeException("MatrixObject not available to indexed read.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._hdfsFileName);
        switch (this._partitionFormat) {
            case ROW_WISE: {
                sb.append("/");
                sb.append(pred.rowStart);
                break;
            }
            case ROW_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)blen + 1L);
                break;
            }
            case ROW_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.rowStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            case COLUMN_WISE: {
                sb.append("/");
                sb.append(pred.colStart);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)blen + 1L);
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                sb.append("/");
                sb.append((pred.colStart - 1L) / (long)this._partitionSize + 1L);
                break;
            }
            default: {
                throw new DMLRuntimeException("MatrixObject not available to indexed read.");
            }
        }
        return sb.toString();
    }

    @Override
    protected boolean isBelowCachingThreshold() {
        return LazyWriteBuffer.getCacheBlockSize(this._data) <= CACHING_THRESHOLD || this.getUpdateType() == UpdateType.INPLACE_PINNED;
    }

    @Override
    protected MatrixBlock readBlobFromCache(String fname) throws IOException {
        return (MatrixBlock)LazyWriteBuffer.readBlock(fname, true);
    }

    @Override
    protected MatrixBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        long rlen = dims[0];
        long clen = dims[1];
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics mc = iimd.getDataCharacteristics();
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading matrix from HDFS...  " + this.hashCode() + "  Path: " + fname + ", dimensions: [" + mc.getRows() + ", " + mc.getCols() + ", " + mc.getNonZeros() + "]"));
            begin = System.currentTimeMillis();
        }
        MatrixBlock newData = this.isFederated() ? (MatrixBlock)this.acquireReadAndRelease() : DataConverter.readMatrixFromHDFS(fname, iimd.getInputInfo(), rlen, clen, mc.getBlocksize(), mc.getNonZeros(), this.getFileFormatProperties());
        this.setHDFSFileExists(true);
        if (newData == null) {
            throw new IOException("Unable to load matrix from file: " + fname);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Reading Completed: " + (System.currentTimeMillis() - begin) + " msec."));
        }
        return newData;
    }

    @Override
    protected MatrixBlock readBlobFromRDD(RDDObject rdd, MutableBoolean writeStatus) throws IOException {
        RDDObject lrdd = rdd;
        writeStatus.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics mc = iimd.getDataCharacteristics();
        InputInfo ii = iimd.getInputInfo();
        MatrixBlock mb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            int rlen = (int)mc.getRows();
            int clen = (int)mc.getCols();
            int blen = mc.getBlocksize();
            long nnz = mc.getNonZerosBound();
            if (ii == InputInfo.BinaryBlockInputInfo && !OptimizerUtils.checkSparkCollectMemoryBudget(mc, MatrixObject.getPinnedSize() + MatrixObject.getBroadcastSize(), true)) {
                if (!HDFSTool.existsFileOnHDFS(this._hdfsFileName)) {
                    long newnnz = SparkExecutionContext.writeRDDtoHDFS(lrdd, this._hdfsFileName, iimd.getOutputInfo());
                    this._metaData.getDataCharacteristics().setNonZeros(newnnz);
                    rdd.setPending(false);
                    rdd.setHDFSFile(true);
                    writeStatus.setValue(true);
                }
                mb = (MatrixBlock)this.readBlobFromHDFS(this._hdfsFileName);
            } else {
                mb = ii == InputInfo.BinaryCellInputInfo ? SparkExecutionContext.toMatrixBlock(lrdd, rlen, clen, nnz) : SparkExecutionContext.toMatrixBlock(lrdd, rlen, clen, blen, nnz);
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (mb == null) {
            throw new IOException("Unable to load matrix from rdd.");
        }
        return mb;
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        long begin = 0L;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" Writing matrix to HDFS...  " + this.hashCode() + "  Path: " + fname + ", Format: " + (ofmt != null ? ofmt : "inferred from metadata")));
            begin = System.currentTimeMillis();
        }
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        if (this._data != null) {
            OutputInfo oinfo;
            DataCharacteristics mc = iimd.getDataCharacteristics();
            OutputInfo outputInfo = oinfo = ofmt != null ? OutputInfo.stringToOutputInfo(ofmt) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
            if (oinfo == OutputInfo.BinaryBlockOutputInfo && DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE && mc.getBlocksize() != ConfigurationManager.getBlocksize()) {
                DataConverter.writeMatrixToHDFS((MatrixBlock)this._data, fname, oinfo, new MatrixCharacteristics(mc.getRows(), mc.getCols(), ConfigurationManager.getBlocksize(), mc.getNonZeros()), rep, fprop, this._diag);
            } else {
                DataConverter.writeMatrixToHDFS((MatrixBlock)this._data, fname, oinfo, mc, rep, fprop, this._diag);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - COMPLETED... " + (System.currentTimeMillis() - begin) + " msec."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writing matrix to HDFS (" + fname + ") - NOTHING TO WRITE (_data == null)."));
        }
        if (DMLScript.STATISTICS) {
            CacheStatistics.incrementHDFSWrites();
        }
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String outputFormat) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        OutputInfo oinfo = outputFormat != null ? OutputInfo.stringToOutputInfo(outputFormat) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        long newnnz = SparkExecutionContext.writeRDDtoHDFS(rdd, fname, oinfo);
        this._metaData.getDataCharacteristics().setNonZeros(newnnz);
    }

    public static enum UpdateType {
        COPY,
        INPLACE,
        INPLACE_PINNED;


        public boolean isInPlace() {
            return this != COPY;
        }
    }
}

