/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.spark.data.RDDObject;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.io.FrameReader;
import org.tugraz.sysds.runtime.io.FrameReaderFactory;
import org.tugraz.sysds.runtime.io.FrameWriter;
import org.tugraz.sysds.runtime.io.FrameWriterFactory;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaData;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class FrameObject
extends CacheableData<FrameBlock> {
    private static final long serialVersionUID = 1755082174281927785L;
    private Types.ValueType[] _schema = null;

    protected FrameObject() {
        super(Types.DataType.FRAME, Types.ValueType.STRING);
    }

    public FrameObject(String fname) {
        this();
        this.setFileName(fname);
    }

    public FrameObject(String fname, MetaData meta) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
    }

    public FrameObject(String fname, MetaData meta, Types.ValueType[] schema) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
        this.setSchema(schema);
    }

    public FrameObject(FrameObject fo) {
        super(fo);
    }

    @Override
    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public Types.ValueType[] getSchema(int cl, int cu) {
        return this._schema != null && this._schema.length > cu ? Arrays.copyOfRange(this._schema, cl, cu + 1) : UtilFunctions.nCopies(cu - cl + 1, Types.ValueType.STRING);
    }

    public Types.ValueType[] mergeSchemas(FrameObject fo) {
        return (Types.ValueType[])ArrayUtils.addAll((Object[])(this._schema != null ? this._schema : UtilFunctions.nCopies((int)this.getNumColumns(), Types.ValueType.STRING)), (Object[])(fo._schema != null ? fo._schema : UtilFunctions.nCopies((int)fo.getNumColumns(), Types.ValueType.STRING)));
    }

    public void setSchema(String schema) {
        if (schema.equals("*")) {
            int clen = (int)this.getNumColumns();
            if (clen >= 0) {
                this._schema = UtilFunctions.nCopies(clen, Types.ValueType.STRING);
            }
        } else {
            String[] parts = schema.split(",");
            this._schema = new Types.ValueType[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                this._schema[i] = Types.ValueType.fromExternalString(parts[i].toUpperCase());
            }
        }
    }

    public void setSchema(Types.ValueType[] schema) {
        this._schema = schema;
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics dc = this._metaData.getDataCharacteristics();
        dc.setDimension(((FrameBlock)this._data).getNumRows(), ((FrameBlock)this._data).getNumColumns());
        dc.setNonZeros(((FrameBlock)this._data).getNumRows() * ((FrameBlock)this._data).getNumColumns());
        this._schema = ((FrameBlock)this._data).getSchema();
    }

    public long getNumRows() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getRows();
    }

    public long getNumColumns() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getCols();
    }

    @Override
    protected FrameBlock readBlobFromCache(String fname) throws IOException {
        return (FrameBlock)LazyWriteBuffer.readBlock(fname, false);
    }

    @Override
    protected FrameBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        long clen = dims[1];
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        Types.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1L ? (int)clen : 1, Types.ValueType.STRING);
        FrameBlock data = null;
        try {
            FrameReader reader = FrameReaderFactory.createFrameReader(iimd.getInputInfo(), this.getFileFormatProperties());
            data = reader.readFrameFromHDFS(fname, lschema, dc.getRows(), dc.getCols());
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (data == null) {
            throw new IOException("Unable to load frame from file: " + fname);
        }
        return data;
    }

    @Override
    protected FrameBlock readBlobFromRDD(RDDObject rdd, MutableBoolean status) throws IOException {
        RDDObject lrdd = rdd;
        status.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        int rlen = (int)dc.getRows();
        int clen = (int)dc.getCols();
        Types.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1 ? clen : 1, Types.ValueType.STRING);
        FrameBlock fb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            fb = SparkExecutionContext.toFrameBlock(lrdd, lschema, rlen, clen);
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (fb == null) {
            throw new IOException("Unable to load frame from rdd.");
        }
        return fb;
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        OutputInfo oinfo = OutputInfo.stringToOutputInfo(ofmt);
        FrameWriter writer = FrameWriterFactory.createFrameWriter(oinfo, fprop);
        writer.writeFrameToHDFS((FrameBlock)this._data, fname, this.getNumRows(), this.getNumColumns());
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String ofmt) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        OutputInfo oinfo = ofmt != null ? OutputInfo.stringToOutputInfo(ofmt) : InputInfo.getMatchingOutputInfo(iimd.getInputInfo());
        SparkExecutionContext.writeFrameRDDtoHDFS(rdd, fname, oinfo);
    }
}

