/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram.caching;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlockDataInput;

public class CacheDataInput
implements DataInput,
MatrixBlockDataInput {
    protected final byte[] _buff;
    protected int _count;

    public CacheDataInput(byte[] mem) {
        this._buff = mem;
        this._count = 0;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public boolean readBoolean() throws IOException {
        return (this._buff[this._count++] & 0xFF) != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)(this._buff[this._count++] & 0xFF);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public short readShort() throws IOException {
        int ret = CacheDataInput.baToShort(this._buff, this._count);
        this._count += 2;
        return (short)ret;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ret = CacheDataInput.baToShort(this._buff, this._count);
        this._count += 2;
        return ret;
    }

    @Override
    public char readChar() throws IOException {
        int ret = CacheDataInput.baToShort(this._buff, this._count);
        this._count += 2;
        return (char)ret;
    }

    @Override
    public int readInt() throws IOException {
        int ret = CacheDataInput.baToInt(this._buff, this._count);
        this._count += 4;
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = CacheDataInput.baToLong(this._buff, this._count);
        this._count += 8;
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        int tmp = CacheDataInput.baToInt(this._buff, this._count);
        float tmp2 = Float.intBitsToFloat(tmp);
        this._count += 4;
        return tmp2;
    }

    @Override
    public double readDouble() throws IOException {
        long tmp = CacheDataInput.baToLong(this._buff, this._count);
        double tmp2 = Double.longBitsToDouble(tmp);
        this._count += 8;
        return tmp2;
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public long readDoubleArray(int len, double[] varr) throws IOException {
        long nnz = 0L;
        int off = this._count;
        for (int i = 0; i < len; ++i) {
            long tmp = CacheDataInput.baToLong(this._buff, off + i * 8);
            varr[i] = Double.longBitsToDouble(tmp);
            nnz += varr[i] != 0.0 ? 1L : 0L;
        }
        this._count = off + len * 8;
        return nnz;
    }

    @Override
    public long readSparseRows(int rlen, long nnz, SparseBlock rows) throws IOException {
        long gnnz = 0L;
        for (int i = 0; i < rlen; ++i) {
            int lnnz = this.readInt();
            if (lnnz <= 0) continue;
            rows.allocate(i, lnnz);
            for (int j = 0; j < lnnz; ++j) {
                int aix = CacheDataInput.baToInt(this._buff, this._count);
                long tmp = CacheDataInput.baToLong(this._buff, this._count + 4);
                double aval = Double.longBitsToDouble(tmp);
                rows.append(i, aix, aval);
                this._count += 12;
            }
            gnnz += (long)lnnz;
        }
        if (gnnz != nnz) {
            throw new IOException("Invalid number of read nnz: " + gnnz + " vs " + nnz);
        }
        return nnz;
    }

    private static int baToShort(byte[] ba, int off) {
        return IOUtilFunctions.baToShort(ba, off);
    }

    private static int baToInt(byte[] ba, int off) {
        return IOUtilFunctions.baToInt(ba, off);
    }

    private static long baToLong(byte[] ba, int off) {
        return IOUtilFunctions.baToLong(ba, off);
    }
}

