/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.parser.WhileStatementBlock;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.DMLScriptException;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;

public class WhileProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private ArrayList<ProgramBlock> _childBlocks;

    public WhileProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._childBlocks = new ArrayList();
    }

    public void addProgramBlock(ProgramBlock childBlock) {
        this._childBlocks.add(childBlock);
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocks;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    private BooleanObject executePredicate(ExecutionContext ec) {
        BooleanObject result = null;
        try {
            if (this._sb != null) {
                WhileStatementBlock wsb = (WhileStatementBlock)this._sb;
                Hop predicateOp = wsb.getPredicateHops();
                boolean recompile = wsb.requiresPredicateRecompilation();
                result = (BooleanObject)this.executePredicate(this._predicate, predicateOp, recompile, Types.ValueType.BOOLEAN, ec);
            } else {
                result = (BooleanObject)this.executePredicate(this._predicate, null, false, Types.ValueType.BOOLEAN, ec);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the while predicate.", ex);
        }
        return result;
    }

    @Override
    public void execute(ExecutionContext ec) {
        try {
            MatrixObject.UpdateType[] flags = this.prepareUpdateInPlaceVariables(ec, this._tid);
            while (this.executePredicate(ec).getBooleanValue()) {
                for (int i = 0; i < this._childBlocks.size(); ++i) {
                    this._childBlocks.get(i).execute(ec);
                }
            }
            this.resetUpdateInPlaceVariableFlags(ec, flags);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating while program block", e);
        }
    }

    public void setChildBlocks(ArrayList<ProgramBlock> childs) {
        this._childBlocks = childs;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in while program block generated from while statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

