/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Level;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.parser.ParForStatementBlock;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.VariableSet;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.ForProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitioner;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitionerLocal;
import org.tugraz.sysds.runtime.controlprogram.parfor.DataPartitionerRemoteSpark;
import org.tugraz.sysds.runtime.controlprogram.parfor.LocalParWorker;
import org.tugraz.sysds.runtime.controlprogram.parfor.LocalTaskQueue;
import org.tugraz.sysds.runtime.controlprogram.parfor.ParForBody;
import org.tugraz.sysds.runtime.controlprogram.parfor.RemoteDPParForSpark;
import org.tugraz.sysds.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.tugraz.sysds.runtime.controlprogram.parfor.RemoteParForSpark;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMergeLocalAutomatic;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMergeLocalFile;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMergeLocalMemory;
import org.tugraz.sysds.runtime.controlprogram.parfor.ResultMergeRemoteSpark;
import org.tugraz.sysds.runtime.controlprogram.parfor.Task;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitioner;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoring;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmax;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmin;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerFixedsize;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerNaive;
import org.tugraz.sysds.runtime.controlprogram.parfor.TaskPartitionerStatic;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.OptimizationWrapper;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.tugraz.sysds.runtime.controlprogram.parfor.opt.ProgramRecompiler;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.Stat;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDHandler;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import org.tugraz.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.tugraz.sysds.runtime.lineage.Lineage;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.util.ProgramConverter;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import org.tugraz.sysds.utils.Statistics;

public class ParForProgramBlock
extends ForProgramBlock {
    public static final boolean OPTIMIZE = true;
    public static final boolean USE_PB_CACHE = false;
    public static final boolean USE_RANGE_TASKS_IF_USEFUL = true;
    public static final boolean USE_STREAMING_TASK_CREATION = true;
    public static final boolean ALLOW_NESTED_PARALLELISM = true;
    public static final boolean USE_PARALLEL_RESULT_MERGE = false;
    public static final boolean USE_PARALLEL_RESULT_MERGE_REMOTE = true;
    public static final boolean ALLOW_DATA_COLOCATION = true;
    public static final boolean CREATE_UNSCOPED_RESULTVARS = true;
    public static boolean ALLOW_REUSE_PARTITION_VARS = true;
    public static final int WRITE_REPLICATION_FACTOR = 1;
    public static final int MAX_RETRYS_ON_ERROR = 1;
    public static final boolean FORCE_CP_ON_REMOTE_SPARK = true;
    public static final boolean LIVEVAR_AWARE_EXPORT = true;
    public static final boolean RESET_RECOMPILATION_FLAGs = true;
    public static final boolean ALLOW_BROADCAST_INPUTS = false;
    public static final String PARFOR_FNAME_PREFIX = "/parfor/";
    public static final String PARFOR_MR_TASKS_TMP_FNAME = "/parfor/%ID%_MR_taskfile";
    public static final String PARFOR_MR_RESULT_TMP_FNAME = "/parfor/%ID%_MR_results";
    public static final String PARFOR_MR_RESULTMERGE_FNAME = "/parfor/%ID%_resultmerge%VAR%";
    public static final String PARFOR_DATAPARTITIONS_FNAME = "/parfor/%ID%_datapartitions%VAR%";
    public static final String PARFOR_COUNTER_GROUP_NAME = "SystemDS ParFOR Counters";
    private static final IDSequence _pfIDSeq = new IDSequence();
    private static final IDSequence _pwIDSeq = new IDSequence();
    protected final HashMap<String, String> _params;
    protected final boolean _monitor;
    protected final Level _optLogLevel;
    protected int _numThreads = -1;
    protected long _taskSize = -1L;
    protected PTaskPartitioner _taskPartitioner = null;
    protected PDataPartitioner _dataPartitioner = null;
    protected PResultMerge _resultMerge = null;
    protected PExecMode _execMode = null;
    protected POptMode _optMode = null;
    protected long _numIterations = -1L;
    protected LocalVariableMap _variablesDPOriginal = null;
    protected LocalVariableMap _variablesDPReuse = null;
    protected String _colocatedDPMatrix = null;
    protected boolean _tSparseCol = false;
    protected int _replicationDP = 1;
    protected int _replicationExport = -1;
    protected boolean _jvmReuse = true;
    protected double _oldMemoryBudget = -1.0;
    protected double _recompileMemoryBudget = -1.0;
    protected boolean _enableCPCaching = true;
    protected boolean _enableRuntimePiggybacking = false;
    protected Collection<String> _variablesRP = null;
    protected Collection<String> _variablesECache = null;
    protected final ArrayList<ParForStatementBlock.ResultVar> _resultVars;
    protected final IDSequence _resultVarsIDSeq;
    protected final IDSequence _dpVarsIDSeq;
    protected final boolean _hasFunctions;
    protected long _ID = -1L;
    protected int _IDPrefix = -1;
    protected boolean _monitorReport = false;
    protected HashMap<Long, ArrayList<ProgramBlock>> _pbcache = null;
    protected long[] _pwIDs = null;

    public ParForProgramBlock(Program prog, String iterPredVar, HashMap<String, String> params, ArrayList<ParForStatementBlock.ResultVar> resultVars) {
        this(-1, prog, iterPredVar, params, resultVars);
    }

    public ParForProgramBlock(int ID, Program prog, String iterPredVar, HashMap<String, String> params, ArrayList<ParForStatementBlock.ResultVar> resultVars) {
        super(prog, iterPredVar);
        this.setParForProgramBlockIDs(ID);
        this._resultVars = resultVars;
        this._resultVarsIDSeq = new IDSequence();
        this._dpVarsIDSeq = new IDSequence();
        this._params = params;
        try {
            this._numThreads = Integer.parseInt(this.getParForParam("par"));
            this._taskPartitioner = PTaskPartitioner.valueOf(this.getParForParam("taskpartitioner"));
            this._taskSize = Integer.parseInt(this.getParForParam("tasksize"));
            this._dataPartitioner = PDataPartitioner.valueOf(this.getParForParam("datapartitioner"));
            this._resultMerge = PResultMerge.valueOf(this.getParForParam("resultmerge"));
            this._execMode = PExecMode.valueOf(this.getParForParam("mode"));
            this._optMode = POptMode.valueOf(this.getParForParam("opt"));
            this._optLogLevel = Level.toLevel((String)this.getParForParam("log"));
            this._monitor = Integer.parseInt(this.getParForParam("profile")) == 1;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing specified ParFOR parameters.", ex);
        }
        this._variablesDPOriginal = new LocalVariableMap();
        this._variablesDPReuse = new LocalVariableMap();
        if (this._execMode == PExecMode.LOCAL) {
            this.setLocalParWorkerIDs();
        }
        this._monitorReport = this._monitor;
        this._hasFunctions = ProgramRecompiler.containsAtLeastOneFunction(this);
        LOG.trace((Object)("PARFOR: ParForProgramBlock created with mode = " + (Object)((Object)this._execMode) + ", optmode = " + (Object)((Object)this._optMode) + ", numThreads = " + this._numThreads));
    }

    public long getID() {
        return this._ID;
    }

    public PExecMode getExecMode() {
        return this._execMode;
    }

    public HashMap<String, String> getParForParams() {
        return this._params;
    }

    public String getParForParam(String key) {
        String tmp = this.getParForParams().get(key);
        return tmp == null ? null : UtilFunctions.unquote(tmp).toUpperCase();
    }

    public ArrayList<ParForStatementBlock.ResultVar> getResultVariables() {
        return this._resultVars;
    }

    public void disableOptimization() {
        this._optMode = POptMode.NONE;
    }

    public POptMode getOptimizationMode() {
        return this._optMode;
    }

    public int getDegreeOfParallelism() {
        return this._numThreads;
    }

    public void setDegreeOfParallelism(int k) {
        this._numThreads = k;
        this._params.put("par", String.valueOf(this._numThreads));
        this.setLocalParWorkerIDs();
    }

    public void setCPCaching(boolean flag) {
        this._enableCPCaching = flag;
    }

    public void setRuntimePiggybacking(boolean flag) {
        this._enableRuntimePiggybacking = flag;
    }

    public void setExecMode(PExecMode mode) {
        this._execMode = mode;
        this._params.put("mode", String.valueOf((Object)this._execMode));
    }

    public void setTaskPartitioner(PTaskPartitioner partitioner) {
        this._taskPartitioner = partitioner;
        this._params.put("taskpartitioner", String.valueOf((Object)this._taskPartitioner));
    }

    public void setTaskSize(long tasksize) {
        this._taskSize = tasksize;
        this._params.put("tasksize", String.valueOf(this._taskSize));
    }

    public void setDataPartitioner(PDataPartitioner partitioner) {
        this._dataPartitioner = partitioner;
        this._params.put("datapartitioner", String.valueOf((Object)this._dataPartitioner));
    }

    public void enableColocatedPartitionedMatrix(String varname) {
        this._colocatedDPMatrix = varname;
    }

    public void setTransposeSparseColumnVector(boolean flag) {
        this._tSparseCol = flag;
    }

    public void setPartitionReplicationFactor(int rep) {
        this._replicationDP = rep;
    }

    public void setExportReplicationFactor(int rep) {
        this._replicationExport = rep;
    }

    public void disableJVMReuse() {
        this._jvmReuse = false;
    }

    public void disableMonitorReport() {
        this._monitorReport = false;
    }

    public void setResultMerge(PResultMerge merge) {
        this._resultMerge = merge;
        this._params.put("resultmerge", String.valueOf((Object)this._resultMerge));
    }

    public void setRecompileMemoryBudget(double localMem) {
        this._recompileMemoryBudget = localMem;
    }

    public void setSparkRepartitionVariables(Collection<String> vars) {
        this._variablesRP = vars;
    }

    public Collection<String> getSparkRepartitionVariables() {
        return this._variablesRP;
    }

    public void setSparkEagerCacheVariables(Collection<String> vars) {
        this._variablesECache = vars;
    }

    public long getNumIterations() {
        return this._numIterations;
    }

    public boolean hasFunctions() {
        return this._hasFunctions;
    }

    @Override
    public void execute(ExecutionContext ec) {
        IntObject incr;
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        IntObject from = this.executePredicateInstructions(1, this._fromInstructions, ec);
        IntObject to = this.executePredicateInstructions(2, this._toInstructions, ec);
        IntObject intObject = this._incrementInstructions == null || this._incrementInstructions.isEmpty() ? new IntObject(from.getLongValue() <= to.getLongValue() ? 1L : -1L) : (incr = this.executePredicateInstructions(3, this._incrementInstructions, ec));
        if (incr.getLongValue() == 0L) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Expression for increment of variable '" + this._iterPredVar + "' must evaluate to a non-zero value.");
        }
        this._numIterations = ParForProgramBlock.computeNumIterations(from, to, incr);
        if (this._numIterations <= 0L) {
            return;
        }
        if (this._optMode != POptMode.NONE) {
            OptimizationWrapper.setLogLevel(this._optLogLevel);
            OptimizationWrapper.optimize(this._optMode, sb, this, ec, this._monitor);
        }
        Timing time = this._monitor ? new Timing(true) : null;
        this.handleDataPartitioning(ec);
        this.handleSparkRepartitioning(ec);
        this.handleSparkEagerCaching(ec);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_DATA_T, time.stop());
        }
        IntObject iterVar = new IntObject(from.getLongValue());
        LOG.trace((Object)("EXECUTE PARFOR ID = " + this._ID + " with mode = " + (Object)((Object)this._execMode) + ", numThreads = " + this._numThreads + ", taskpartitioner = " + (Object)((Object)this._taskPartitioner)));
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTHREADS, this._numThreads);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_TASKSIZE, this._taskSize);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_TASKPARTITIONER, this._taskPartitioner.ordinal());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_DATAPARTITIONER, this._dataPartitioner.ordinal());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_EXECMODE, this._execMode.ordinal());
        }
        ArrayList<String> varList = ec.getVarList();
        boolean[] varState = ec.pinVariables(varList);
        try {
            switch (this._execMode) {
                case LOCAL: {
                    this.executeLocalParFor(ec, iterVar, from, to, incr);
                    break;
                }
                case REMOTE_SPARK: {
                    this.executeRemoteSparkParFor(ec, iterVar, from, to, incr);
                    break;
                }
                case REMOTE_SPARK_DP: {
                    this.executeRemoteSparkParForDP(ec, iterVar, from, to, incr);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Undefined execution mode: '" + (Object)((Object)this._execMode) + "'.");
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("PARFOR: Failed to execute loop in parallel.", ex);
        }
        ec.unpinVariables(varList, varState);
        this.cleanupSharedVariables(ec, varState);
        iterVar = new IntObject(to.getLongValue());
        ec.setVariable(this._iterPredVar, iterVar);
        for (String var : this._variablesDPOriginal.keySet()) {
            if (!this._variablesDPReuse.keySet().contains(var)) {
                VariableCPInstruction.processRemoveVariableInstruction(ec, var);
            }
            MatrixObject mo = (MatrixObject)this._variablesDPOriginal.get(var);
            ec.setVariable(var, mo);
        }
        if (this._monitorReport) {
            LOG.info((Object)("\n" + StatisticMonitor.createReport()));
        }
        for (String dpvar : this._variablesDPOriginal.keySet()) {
            ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, dpvar, ec, false);
        }
        if (this._execMode == PExecMode.REMOTE_SPARK_DP) {
            ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, this._colocatedDPMatrix, ec, false);
        }
        this.resetOptimizerFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocalParFor(ExecutionContext ec, IntObject itervar, IntObject from, IntObject to, IntObject incr) throws InterruptedException {
        LOG.trace((Object)("Local Par For (multi-threaded) with degree of parallelism : " + this._numThreads));
        Timing time = new Timing(true);
        int numExecutedTasks = 0;
        int numExecutedIterations = 0;
        this.setMemoryBudget();
        try {
            LocalTaskQueue<Task> queue = new LocalTaskQueue<Task>();
            Thread[] threads = new Thread[this._numThreads];
            LocalParWorker[] workers = new LocalParWorker[this._numThreads];
            IntStream.range(0, this._numThreads).parallel().forEach(i -> {
                workers[i] = this.createParallelWorker(this._pwIDs[i], queue, ec, i);
                threads[i] = new Thread(workers[i]);
                threads[i].setPriority(10);
            });
            for (Thread thread : threads) {
                thread.start();
            }
            long tinit = (long)time.stop();
            if (DMLScript.STATISTICS) {
                Statistics.incrementParForInitTime(tinit);
            }
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, tinit);
            }
            TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
            long numIterations = partitioner.getNumIterations();
            long numCreatedTasks = -1L;
            numCreatedTasks = partitioner.createTasks(queue);
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
            }
            for (Thread thread : threads) {
                thread.join();
            }
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
            }
            LocalVariableMap[] localVariables = new LocalVariableMap[this._numThreads];
            for (int i2 = 0; i2 < this._numThreads; ++i2) {
                localVariables[i2] = workers[i2].getVariables();
                localVariables[i2].removeAllNotIn(this._resultVars.stream().map(v -> v._name).collect(Collectors.toSet()));
                numExecutedTasks = (int)((long)numExecutedTasks + workers[i2].getExecutedTasks());
                numExecutedIterations = (int)((long)numExecutedIterations + workers[i2].getExecutedIterations());
            }
            Lineage[] lineages = (Lineage[])Arrays.stream(workers).filter(w -> w.getExecutedTasks() >= 1L).map(w -> w.getExecutionContext().getLineage()).toArray(Lineage[]::new);
            this.mergeLineage(ec, lineages);
            this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, localVariables);
            for (int i3 = 0; i3 < this._numThreads; ++i3) {
                Collection<String> fnNames = workers[i3].getFunctionNames();
                if (fnNames == null || fnNames.isEmpty()) continue;
                for (String fn : fnNames) {
                    String[] parts = DMLProgram.splitFunctionKey(fn);
                    this._prog.removeFunctionProgramBlock(parts[0], parts[1]);
                }
            }
            if (DMLScript.USE_ACCELERATOR) {
                ec.getGPUContext(0).initializeThread();
            }
        }
        finally {
            this.resetMemoryBudget();
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
            }
        }
    }

    private void executeRemoteSparkParFor(ExecutionContext ec, IntObject itervar, IntObject from, IntObject to, IntObject incr) {
        Timing time = this._monitor ? new Timing(true) : null;
        boolean flagForced = false;
        if (this._optMode == POptMode.NONE || this._optMode == POptMode.CONSTRAINED && this._execMode == PExecMode.REMOTE_SPARK) {
            flagForced = this.checkMRAndRecompileToCP(0L);
        }
        ParForBody body = new ParForBody(this._childBlocks, this._resultVars, ec);
        HashMap<String, byte[]> clsMap = new HashMap<String, byte[]>();
        String program = ProgramConverter.serializeParForBody(body, clsMap);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, time.stop());
        }
        TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
        long numIterations = partitioner.getNumIterations();
        List<Task> tasks = partitioner.createTasks();
        long numCreatedTasks = tasks.size();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
        }
        this.exportMatricesToHDFS(ec, new String[0]);
        boolean topLevelPF = OptimizerUtils.isTopLevelParFor();
        RemoteParForJobReturn ret = RemoteParForSpark.runJob(this._ID, program, clsMap, tasks, ec, this._resultVars, this._enableCPCaching, this._numThreads, topLevelPF);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
        }
        int numExecutedTasks = ret.getNumExecutedTasks();
        int numExecutedIterations = ret.getNumExecutedIterations();
        this.mergeLineage(ec, ret.getLineages());
        this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, ret.getVariables());
        if (flagForced) {
            this.releaseForcedRecompile(0L);
        }
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
        }
    }

    private void executeRemoteSparkParForDP(ExecutionContext ec, IntObject itervar, IntObject from, IntObject to, IntObject incr) {
        long numIterations;
        Timing time = this._monitor ? new Timing(true) : null;
        boolean flagForced = this.checkMRAndRecompileToCP(0L);
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        MatrixObject inputMatrix = ec.getMatrixObject(this._colocatedDPMatrix);
        PartitionFormat inputDPF = sb.determineDataPartitionFormat(this._colocatedDPMatrix);
        inputMatrix.setPartitioned(inputDPF._dpf, inputDPF._N);
        ParForBody body = new ParForBody(this._childBlocks, this._resultVars, ec);
        HashMap<String, byte[]> clsMap = new HashMap<String, byte[]>();
        String program = ProgramConverter.serializeParForBody(body, clsMap);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, time.stop());
        }
        TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
        String resultFile = this.constructResultFileName();
        long numCreatedTasks = numIterations = partitioner.getNumIterations();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
        }
        this.exportMatricesToHDFS(ec, this._colocatedDPMatrix);
        OutputInfo inputOI = OutputInfo.BinaryBlockOutputInfo;
        RemoteParForJobReturn ret = RemoteDPParForSpark.runJob(this._ID, this._iterPredVar, this._colocatedDPMatrix, program, clsMap, resultFile, inputMatrix, ec, inputDPF, inputOI, this._tSparseCol, this._enableCPCaching, this._numThreads);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
        }
        int numExecutedTasks = ret.getNumExecutedTasks();
        int numExecutedIterations = ret.getNumExecutedIterations();
        this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, ret.getVariables());
        if (flagForced) {
            this.releaseForcedRecompile(0L);
        }
        inputMatrix.unsetPartitioned();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
        }
    }

    private void handleDataPartitioning(ExecutionContext ec) {
        PDataPartitioner dataPartitioner = this._dataPartitioner;
        if (dataPartitioner != PDataPartitioner.NONE) {
            ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
            if (sb == null) {
                throw new DMLRuntimeException("ParFor statement block required for reasoning about data partitioning.");
            }
            for (String var : sb.getReadOnlyParentMatrixVars()) {
                Data dat = ec.getVariable(var);
                if (dat == null || !(dat instanceof MatrixObject)) continue;
                MatrixObject moVar = (MatrixObject)dat;
                PartitionFormat dpf = sb.determineDataPartitionFormat(var);
                LOG.trace((Object)("PARFOR ID = " + this._ID + ", Partitioning read-only input variable " + var + " (format=" + dpf + ", mode=" + (Object)((Object)this._dataPartitioner) + ")"));
                if (dpf == PartitionFormat.NONE) continue;
                if (dataPartitioner != PDataPartitioner.REMOTE_SPARK && dpf.isBlockwise()) {
                    LOG.warn((Object)("PARFOR ID = " + this._ID + ", Switching data partitioner from " + (Object)((Object)dataPartitioner) + " to " + PDataPartitioner.REMOTE_SPARK.name() + " for blockwise-n partitioning."));
                    dataPartitioner = PDataPartitioner.REMOTE_SPARK;
                }
                Timing ltime = new Timing(true);
                Data dpdatNew = this._variablesDPReuse.get(var);
                if (dpdatNew == null) {
                    DataPartitioner dp = this.createDataPartitioner(dpf, dataPartitioner, ec);
                    if (!OptimizerRuleBased.allowsBinaryCellPartitions(moVar, dpf) || OptimizerUtils.isSparkExecutionMode()) {
                        dp.disableBinaryCell();
                    }
                    MatrixObject moVarNew = dp.createPartitionedMatrixObject(moVar, this.constructDataPartitionsFileName());
                    dpdatNew = moVarNew;
                    if (moVar == moVarNew) continue;
                }
                ec.setVariable(var, dpdatNew);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, var, ec, true);
                this._variablesDPOriginal.put(var, moVar);
                if (ALLOW_REUSE_PARTITION_VARS && ProgramRecompiler.isApplicableForReuseVariable(sb.getDMLProg(), (StatementBlock)sb, var)) {
                    this._variablesDPReuse.put(var, dpdatNew);
                }
                LOG.trace((Object)("Partitioning and recompilation done in " + ltime.stop() + "ms"));
            }
        }
    }

    private void handleSparkRepartitioning(ExecutionContext ec) {
        if (OptimizerUtils.isSparkExecutionMode() && this._variablesRP != null && !this._variablesRP.isEmpty()) {
            SparkExecutionContext sec = (SparkExecutionContext)ec;
            for (String var : this._variablesRP) {
                sec.repartitionAndCacheMatrixObject(var);
            }
        }
    }

    private void handleSparkEagerCaching(ExecutionContext ec) {
        if (OptimizerUtils.isSparkExecutionMode() && this._variablesECache != null && !this._variablesECache.isEmpty()) {
            SparkExecutionContext sec = (SparkExecutionContext)ec;
            for (String var : this._variablesECache) {
                sec.cacheMatrixObject(var);
            }
        }
    }

    private static void cleanWorkerResultVariables(ExecutionContext ec, MatrixObject out, MatrixObject[] in) {
        for (MatrixObject tmp : in) {
            if (tmp == null || tmp == out) continue;
            ec.cleanupCacheableData(tmp);
        }
    }

    private static void createEmptyUnscopedVariables(LocalVariableMap out, StatementBlock sb) {
        VariableSet updated = sb.variablesUpdated();
        VariableSet livein = sb.liveIn();
        for (String var : updated.getVariableNames()) {
            if (livein.containsVariable(var)) continue;
            DataIdentifier dat = updated.getVariable(var);
            Types.DataType datatype = dat.getDataType();
            Types.ValueType valuetype = dat.getValueType();
            Data dataObj = null;
            block0 : switch (datatype) {
                case SCALAR: {
                    switch (valuetype) {
                        case BOOLEAN: {
                            dataObj = new BooleanObject(false);
                            break block0;
                        }
                        case INT64: {
                            dataObj = new IntObject(-1L);
                            break block0;
                        }
                        case FP64: {
                            dataObj = new DoubleObject(-1.0);
                            break block0;
                        }
                        case STRING: {
                            dataObj = new StringObject("-1");
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Value type not supported: " + (Object)((Object)valuetype));
                }
                case MATRIX: 
                case FRAME: {
                    break;
                }
                case LIST: {
                    dataObj = new ListObject(Collections.emptyList());
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Data type not supported: " + (Object)((Object)datatype));
                }
            }
            if (dataObj == null) continue;
            out.put(var, dataObj);
        }
    }

    private void exportMatricesToHDFS(ExecutionContext ec, String ... blacklistNames) {
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        Set<String> blacklist = UtilFunctions.asSet(blacklistNames);
        if (sb != null) {
            VariableSet varsRead = sb.variablesRead();
            for (String key : ec.getVariables().keySet()) {
                Data d;
                if (!varsRead.containsVariable(key) || blacklist.contains(key) || (d = ec.getVariable(key)).getDataType() != Types.DataType.MATRIX) continue;
                ((MatrixObject)d).exportData(this._replicationExport);
            }
        } else {
            for (String key : ec.getVariables().keySet()) {
                Data d;
                if (blacklist.contains(key) || (d = ec.getVariable(key)).getDataType() != Types.DataType.MATRIX) continue;
                ((MatrixObject)d).exportData(this._replicationExport);
            }
        }
    }

    private void cleanupSharedVariables(ExecutionContext ec, boolean[] varState) {
    }

    private LocalParWorker createParallelWorker(long pwID, LocalTaskQueue<Task> queue, ExecutionContext ec, int index) {
        LocalParWorker pw = null;
        try {
            ArrayList<ProgramBlock> cpChildBlocks = null;
            HashSet<String> fnNames = new HashSet<String>();
            cpChildBlocks = ProgramConverter.rcreateDeepCopyProgramBlocks(this._childBlocks, pwID, this._IDPrefix, new HashSet<String>(), fnNames, false, false);
            ExecutionContext cpEc = ProgramConverter.createDeepCopyExecutionContext(ec);
            if (DMLScript.USE_ACCELERATOR) {
                cpEc.setGPUContexts(Arrays.asList(ec.getGPUContext(index)));
            }
            this.prepareUpdateInPlaceVariables(cpEc, pwID);
            CompilerConfig cconf = ConfigurationManager.getCompilerConfig();
            ParForBody body = new ParForBody(cpChildBlocks, this._resultVars, cpEc);
            pw = new LocalParWorker(pwID, queue, body, cconf, 1, this._monitor);
            pw.setFunctionNames(fnNames);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return pw;
    }

    private TaskPartitioner createTaskPartitioner(IntObject from, IntObject to, IntObject incr) {
        TaskPartitioner tp = null;
        switch (this._taskPartitioner) {
            case FIXED: {
                tp = new TaskPartitionerFixedsize(this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case NAIVE: {
                tp = new TaskPartitionerNaive(this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case STATIC: {
                tp = new TaskPartitionerStatic(this._taskSize, this._numThreads, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING: {
                tp = new TaskPartitionerFactoring(this._taskSize, this._numThreads, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING_CMIN: {
                tp = new TaskPartitionerFactoringCmin(this._taskSize, this._numThreads, this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING_CMAX: {
                tp = new TaskPartitionerFactoringCmax(this._taskSize, this._numThreads, this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            default: {
                throw new DMLRuntimeException("Undefined task partitioner: '" + (Object)((Object)this._taskPartitioner) + "'.");
            }
        }
        return tp;
    }

    private DataPartitioner createDataPartitioner(PartitionFormat dpf, PDataPartitioner dataPartitioner, ExecutionContext ec) {
        DataPartitioner dp = null;
        int numRed = OptimizerUtils.isSparkExecutionMode() ? SparkExecutionContext.getDefaultParallelism(false) : 1;
        switch (dataPartitioner) {
            case LOCAL: {
                dp = new DataPartitionerLocal(dpf, this._numThreads);
                break;
            }
            case REMOTE_SPARK: {
                dp = new DataPartitionerRemoteSpark(dpf, ec, numRed, this._replicationDP, false);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unknown data partitioner: '" + dataPartitioner.name() + "'.");
            }
        }
        return dp;
    }

    private ResultMerge createResultMerge(PResultMerge prm, MatrixObject out, MatrixObject[] in, String fname, boolean accum, ExecutionContext ec) {
        ResultMerge rm = null;
        switch (prm) {
            case LOCAL_MEM: {
                rm = new ResultMergeLocalMemory(out, in, fname, accum);
                break;
            }
            case LOCAL_FILE: {
                rm = new ResultMergeLocalFile(out, in, fname, accum);
                break;
            }
            case LOCAL_AUTOMATIC: {
                rm = new ResultMergeLocalAutomatic(out, in, fname, accum);
                break;
            }
            case REMOTE_SPARK: {
                int numMap;
                int numRed = numMap = Math.max(this._numThreads, SparkExecutionContext.getDefaultParallelism(true));
                rm = new ResultMergeRemoteSpark(out, in, fname, accum, ec, numMap, numRed);
                break;
            }
            default: {
                throw new DMLRuntimeException("Undefined result merge: '" + prm.toString() + "'.");
            }
        }
        return rm;
    }

    private boolean checkMRAndRecompileToCP(long tid) {
        if (!OptTreeConverter.rContainsMRJobInstruction(this, true)) {
            return false;
        }
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        if (sb == null) {
            LOG.warn((Object)"Missing parfor statement block for recompile.");
            return false;
        }
        HashSet<String> fnStack = new HashSet<String>();
        Recompiler.recompileProgramBlockHierarchy2Forced(this._childBlocks, tid, fnStack, LopProperties.ExecType.CP);
        return true;
    }

    private void releaseForcedRecompile(long tid) {
        Recompiler.recompileProgramBlockHierarchy2Forced(this._childBlocks, tid, new HashSet<String>(), null);
    }

    private void mergeLineage(ExecutionContext ec, Lineage[] lineages) {
        if (!DMLScript.LINEAGE) {
            return;
        }
        for (ParForStatementBlock.ResultVar var : this._resultVars) {
            LineageItem retIn = ec.getLineage().get(var._name);
            LineageItem current = lineages[0].get(var._name);
            for (int i = 1; i < lineages.length; ++i) {
                LineageItem next = lineages[i].get(var._name);
                current = LineageItemUtils.replace(next, retIn, current);
            }
            ec.getLineage().set(var._name, current);
        }
    }

    private void consolidateAndCheckResults(ExecutionContext ec, long expIters, long expTasks, long numIters, long numTasks, LocalVariableMap[] results) {
        ParForStatementBlock sb;
        Timing time = new Timing(true);
        if (this.checkParallelRemoteResultMerge()) {
            int par = Math.min(this._resultVars.size(), InfrastructureAnalyzer.getLocalParallelism());
            if (InfrastructureAnalyzer.isLocalMode()) {
                int parmem = (int)Math.floor(OptimizerUtils.getLocalMemBudget());
                par = Math.min(par, Math.max(parmem, 1));
            }
            try {
                int i;
                LocalTaskQueue<ParForStatementBlock.ResultVar> q = new LocalTaskQueue<ParForStatementBlock.ResultVar>();
                for (ParForStatementBlock.ResultVar var : this._resultVars) {
                    if (!(ec.getVariable(var._name) instanceof MatrixObject)) continue;
                    q.enqueueTask(var);
                }
                q.closeInput();
                ResultMergeWorker[] rmWorkers = new ResultMergeWorker[par];
                for (i = 0; i < par; ++i) {
                    rmWorkers[i] = new ResultMergeWorker(q, results, ec);
                }
                for (i = 0; i < par; ++i) {
                    rmWorkers[i].start();
                }
                for (i = 0; i < par; ++i) {
                    rmWorkers[i].join();
                    if (rmWorkers[i].finishedNoError()) continue;
                    throw new DMLRuntimeException("Error occured in parallel result merge worker.");
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        } else {
            for (ParForStatementBlock.ResultVar var : this._resultVars) {
                Data dat = ec.getVariable(var._name);
                if (dat instanceof MatrixObject) {
                    MatrixObject out = (MatrixObject)dat;
                    MatrixObject[] in = (MatrixObject[])Arrays.stream(results).map(vars -> vars.get(var._name)).toArray(MatrixObject[]::new);
                    String fname = this.constructResultMergeFileName();
                    ResultMerge rm = this.createResultMerge(this._resultMerge, out, in, fname, var._isAccum, ec);
                    MatrixObject outNew = rm.executeSerialMerge();
                    Data exdata = ec.removeVariable(var._name);
                    if (exdata != null && exdata != outNew) {
                        ec.cleanupDataObject(exdata);
                    }
                    ParForProgramBlock.cleanWorkerResultVariables(ec, out, in);
                    ec.setVariable(var._name, outNew);
                    continue;
                }
                if (!(dat instanceof ListObject)) continue;
                ListObject oldList = (ListObject)dat;
                ListObject newList = new ListObject(oldList);
                ListObject[] in = (ListObject[])Arrays.stream(results).map(vars -> vars.get(var._name)).toArray(ListObject[]::new);
                block7: for (int i = 0; i < oldList.getLength(); ++i) {
                    Data compare = oldList.slice(i);
                    for (int j = 0; j < in.length; ++j) {
                        Data tmp = in[j].slice(i);
                        if (compare == tmp) continue;
                        newList.set(i, tmp);
                        continue block7;
                    }
                }
                ec.setVariable(var._name, newList);
            }
        }
        if ((sb = (ParForStatementBlock)this.getStatementBlock()) != null && ec.getVariables() != null) {
            ParForProgramBlock.createEmptyUnscopedVariables(ec.getVariables(), sb);
        }
        if (numTasks != expTasks || numIters != expIters) {
            throw new DMLRuntimeException("PARFOR: Number of executed tasks does not match the number of created tasks: tasks " + numTasks + "/" + expTasks + ", iters " + numIters + "/" + expIters + ".");
        }
        if (DMLScript.STATISTICS) {
            Statistics.incrementParForMergeTime((long)time.stop());
        }
    }

    private boolean checkParallelRemoteResultMerge() {
        return this._resultVars.size() > 1 && this._resultMerge == PResultMerge.REMOTE_SPARK;
    }

    private void setParForProgramBlockIDs(int IDPrefix) {
        this._IDPrefix = IDPrefix;
        this._ID = this._IDPrefix == -1 ? _pfIDSeq.getNextID() : IDHandler.concatIntIDsToLong(this._IDPrefix, (int)_pfIDSeq.getNextID());
    }

    private void setLocalParWorkerIDs() {
        if (this._numThreads <= 0) {
            return;
        }
        this._pwIDs = new long[this._numThreads];
        for (int i = 0; i < this._numThreads; ++i) {
            this._pwIDs[i] = this._IDPrefix == -1 ? _pwIDSeq.getNextID() : IDHandler.concatIntIDsToLong(this._IDPrefix, (int)_pwIDSeq.getNextID());
            if (!this._monitor) continue;
            StatisticMonitor.putPfPwMapping(this._ID, this._pwIDs[i]);
        }
    }

    private static long computeNumIterations(IntObject from, IntObject to, IntObject incr) {
        return (long)Math.ceil((double)(to.getLongValue() - from.getLongValue() + 1L) / (double)incr.getLongValue());
    }

    private String constructResultFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(PARFOR_MR_RESULT_TMP_FNAME.replaceAll("%ID%", String.valueOf(this._ID)));
        return sb.toString();
    }

    private String constructResultMergeFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        String fname = PARFOR_MR_RESULTMERGE_FNAME;
        fname = fname.replaceAll("%ID%", String.valueOf(this._ID));
        fname = fname.replaceAll("%VAR%", String.valueOf(this._resultVarsIDSeq.getNextID()));
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(fname);
        return sb.toString();
    }

    private String constructDataPartitionsFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        String fname = PARFOR_DATAPARTITIONS_FNAME;
        fname = fname.replaceAll("%ID%", String.valueOf(this._ID));
        fname = fname.replaceAll("%VAR%", String.valueOf(this._dpVarsIDSeq.getNextID()));
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(fname);
        return sb.toString();
    }

    private void setMemoryBudget() {
        if (this._recompileMemoryBudget > 0.0) {
            this._oldMemoryBudget = InfrastructureAnalyzer.getLocalMaxMemory();
            long newMaxMem = (long)(this._recompileMemoryBudget / OptimizerUtils.MEM_UTIL_FACTOR);
            InfrastructureAnalyzer.setLocalMaxMemory(newMaxMem);
        }
    }

    private void resetMemoryBudget() {
        if (this._recompileMemoryBudget > 0.0) {
            InfrastructureAnalyzer.setLocalMaxMemory((long)this._oldMemoryBudget);
        }
    }

    private void resetOptimizerFlags() {
        this._variablesDPOriginal.removeAll();
        this._colocatedDPMatrix = null;
        this._replicationDP = 1;
        this._replicationExport = -1;
        this._jvmReuse = true;
        this._recompileMemoryBudget = -1.0;
        this._enableRuntimePiggybacking = false;
        this._variablesRP = null;
        this._variablesECache = null;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in parfor program block generated from parfor statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    private class ResultMergeWorker
    extends Thread {
        private LocalTaskQueue<ParForStatementBlock.ResultVar> _q = null;
        private LocalVariableMap[] _refVars = null;
        private ExecutionContext _ec = null;
        private boolean _success = false;

        public ResultMergeWorker(LocalTaskQueue<ParForStatementBlock.ResultVar> q, LocalVariableMap[] results, ExecutionContext ec) {
            this._q = q;
            this._refVars = results;
            this._ec = ec;
        }

        public boolean finishedNoError() {
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ParForStatementBlock.ResultVar var;
                while ((var = this._q.dequeueTask()) != LocalTaskQueue.NO_MORE_TASKS) {
                    MatrixObject out = null;
                    LocalVariableMap localVariableMap = this._ec.getVariables();
                    synchronized (localVariableMap) {
                        out = this._ec.getMatrixObject(var._name);
                    }
                    MatrixObject[] in = new MatrixObject[this._refVars.length];
                    for (int i = 0; i < this._refVars.length; ++i) {
                        in[i] = (MatrixObject)this._refVars[i].get(var._name);
                    }
                    String fname = ParForProgramBlock.this.constructResultMergeFileName();
                    ResultMerge rm = ParForProgramBlock.this.createResultMerge(ParForProgramBlock.this._resultMerge, out, in, fname, var._isAccum, this._ec);
                    MatrixObject outNew = null;
                    outNew = rm.executeSerialMerge();
                    LocalVariableMap localVariableMap2 = this._ec.getVariables();
                    synchronized (localVariableMap2) {
                        this._ec.getVariables().put(var._name, outNew);
                    }
                    ParForProgramBlock.cleanWorkerResultVariables(this._ec, out, in);
                }
                this._success = true;
            }
            catch (Exception ex) {
                ProgramBlock.LOG.error((Object)"Error executing result merge: ", (Throwable)ex);
            }
        }
    }

    public static enum POptMode {
        NONE,
        RULEBASED,
        CONSTRAINED,
        HEURISTIC;

    }

    public static enum PResultMerge {
        LOCAL_MEM,
        LOCAL_FILE,
        LOCAL_AUTOMATIC,
        REMOTE_SPARK,
        UNSPECIFIED;


        public boolean isLocal() {
            return this == LOCAL_MEM || this == LOCAL_FILE || this == LOCAL_AUTOMATIC;
        }
    }

    public static enum PDataPartitioner {
        NONE,
        LOCAL,
        REMOTE_SPARK,
        UNSPECIFIED;

    }

    public static class PartitionFormat
    implements Serializable {
        private static final long serialVersionUID = 4729309847778707801L;
        public static final PartitionFormat NONE = new PartitionFormat(PDataPartitionFormat.NONE, -1);
        public static final PartitionFormat ROW_WISE = new PartitionFormat(PDataPartitionFormat.ROW_WISE, -1);
        public static final PartitionFormat COLUMN_WISE = new PartitionFormat(PDataPartitionFormat.COLUMN_WISE, -1);
        public final PDataPartitionFormat _dpf;
        public final int _N;

        public PartitionFormat(PDataPartitionFormat dpf, int N) {
            this._dpf = dpf;
            this._N = N;
        }

        public int hashCode() {
            return UtilFunctions.intHashCode(this._dpf.ordinal(), this._N);
        }

        public boolean equals(Object o) {
            return o instanceof PartitionFormat && this._dpf == ((PartitionFormat)o)._dpf && this._N == ((PartitionFormat)o)._N;
        }

        public String toString() {
            return this._dpf.name() + "," + this._N;
        }

        public static PartitionFormat valueOf(String value) {
            String[] parts = value.split(",");
            return new PartitionFormat(PDataPartitionFormat.parsePDataPartitionFormat(parts[0]), Integer.parseInt(parts[1]));
        }

        public boolean isBlockwise() {
            return this._dpf == PDataPartitionFormat.COLUMN_BLOCK_WISE_N || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE_N;
        }

        public boolean isRowwise() {
            return this._dpf == PDataPartitionFormat.ROW_WISE || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE_N;
        }

        public long getNumParts(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return mc.getRows();
                }
                case ROW_BLOCK_WISE: {
                    return mc.getNumRowBlocks();
                }
                case ROW_BLOCK_WISE_N: {
                    return (long)Math.ceil((double)mc.getRows() / (double)this._N);
                }
                case COLUMN_WISE: {
                    return mc.getCols();
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getNumColBlocks();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return (long)Math.ceil((double)mc.getCols() / (double)this._N);
                }
            }
            throw new RuntimeException("Unsupported partition format: " + (Object)((Object)this._dpf));
        }

        public long getNumRows(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return 1L;
                }
                case ROW_BLOCK_WISE: {
                    return mc.getBlocksize();
                }
                case ROW_BLOCK_WISE_N: {
                    return this._N;
                }
                case COLUMN_WISE: {
                    return mc.getRows();
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getRows();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return mc.getRows();
                }
            }
            throw new RuntimeException("Unsupported partition format: " + (Object)((Object)this._dpf));
        }

        public long getNumColumns(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return mc.getCols();
                }
                case ROW_BLOCK_WISE: {
                    return mc.getCols();
                }
                case ROW_BLOCK_WISE_N: {
                    return mc.getCols();
                }
                case COLUMN_WISE: {
                    return 1L;
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getBlocksize();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return this._N;
                }
            }
            throw new RuntimeException("Unsupported partition format: " + (Object)((Object)this._dpf));
        }
    }

    public static enum PDataPartitionFormat {
        NONE,
        ROW_WISE,
        ROW_BLOCK_WISE,
        ROW_BLOCK_WISE_N,
        COLUMN_WISE,
        COLUMN_BLOCK_WISE,
        COLUMN_BLOCK_WISE_N,
        BLOCK_WISE_M_N;


        public static PDataPartitionFormat parsePDataPartitionFormat(String s) {
            if (s.equalsIgnoreCase("ROW_WISE")) {
                return ROW_WISE;
            }
            if (s.equalsIgnoreCase("ROW_BLOCK_WISE")) {
                return ROW_BLOCK_WISE;
            }
            if (s.equalsIgnoreCase("ROW_BLOCK_WISE_N")) {
                return ROW_BLOCK_WISE_N;
            }
            if (s.equalsIgnoreCase("COLUMN_WISE")) {
                return COLUMN_WISE;
            }
            if (s.equalsIgnoreCase("COLUMN_BLOCK_WISE")) {
                return COLUMN_BLOCK_WISE;
            }
            if (s.equalsIgnoreCase("COLUMN_BLOCK_WISE_N")) {
                return COLUMN_BLOCK_WISE_N;
            }
            if (s.equalsIgnoreCase("BLOCK_WISE_M_N")) {
                return BLOCK_WISE_M_N;
            }
            return NONE;
        }
    }

    public static enum PTaskPartitioner {
        FIXED,
        NAIVE,
        STATIC,
        FACTORING,
        FACTORING_CMIN,
        FACTORING_CMAX,
        UNSPECIFIED;

    }

    public static enum PExecMode {
        LOCAL,
        REMOTE_SPARK,
        REMOTE_SPARK_DP,
        UNSPECIFIED;

    }
}

