/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.parser.IfStatementBlock;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.DMLScriptException;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;

public class IfProgramBlock
extends ProgramBlock {
    private ArrayList<Instruction> _predicate;
    private ArrayList<Instruction> _exitInstructions;
    private ArrayList<ProgramBlock> _childBlocksIfBody = new ArrayList();
    private ArrayList<ProgramBlock> _childBlocksElseBody = new ArrayList();

    public IfProgramBlock(Program prog, ArrayList<Instruction> predicate) {
        super(prog);
        this._predicate = predicate;
        this._exitInstructions = new ArrayList();
    }

    public ArrayList<ProgramBlock> getChildBlocksIfBody() {
        return this.getChildBlocks();
    }

    public void setChildBlocksIfBody(ArrayList<ProgramBlock> blocks) {
        this._childBlocksIfBody = blocks;
    }

    public void addProgramBlockIfBody(ProgramBlock pb) {
        this._childBlocksIfBody.add(pb);
    }

    public ArrayList<ProgramBlock> getChildBlocksElseBody() {
        return this._childBlocksElseBody;
    }

    public void setChildBlocksElseBody(ArrayList<ProgramBlock> blocks) {
        this._childBlocksElseBody = blocks;
    }

    public void addProgramBlockElseBody(ProgramBlock pb) {
        this._childBlocksElseBody.add(pb);
    }

    public ArrayList<Instruction> getPredicate() {
        return this._predicate;
    }

    public void setPredicate(ArrayList<Instruction> predicate) {
        this._predicate = predicate;
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return this._childBlocksIfBody;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public void execute(ExecutionContext ec) {
        int i;
        BooleanObject predResult = this.executePredicate(ec);
        if (DMLScript.LINEAGE_DEDUP) {
            ec.getLineagePath().setBranchPredicateValue(predResult.getBooleanValue());
        }
        if (predResult.getBooleanValue()) {
            try {
                for (i = 0; i < this._childBlocksIfBody.size(); ++i) {
                    this._childBlocksIfBody.get(i).execute(ec);
                }
            }
            catch (DMLScriptException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating if statement body ", e);
            }
        }
        try {
            for (i = 0; i < this._childBlocksElseBody.size(); ++i) {
                this._childBlocksElseBody.get(i).execute(ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating else statement body ", e);
        }
        try {
            this.executeInstructions(this._exitInstructions, ec);
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating if exit instructions ", e);
        }
    }

    private BooleanObject executePredicate(ExecutionContext ec) {
        BooleanObject result = null;
        try {
            if (this._sb != null) {
                IfStatementBlock isb = (IfStatementBlock)this._sb;
                result = (BooleanObject)this.executePredicate(this._predicate, isb.getPredicateHops(), isb.requiresPredicateRecompilation(), Types.ValueType.BOOLEAN, ec);
            } else {
                result = (BooleanObject)this.executePredicate(this._predicate, null, false, Types.ValueType.BOOLEAN, ec);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to evaluate the IF predicate.", ex);
        }
        return result;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in if program block generated from if statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }
}

